"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagePrivateLocations = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _monitor_detail_flyout = require("../../monitors_page/overview/overview/monitor_detail_flyout");
var _locations_table = require("./locations_table");
var _manage_empty_state = require("./manage_empty_state");
var _add_location_flyout = require("./add_location_flyout");
var _use_locations_api = require("./hooks/use_locations_api");
var _private_locations = require("../../../state/private_locations");
var _state = require("../../../state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManagePrivateLocations = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isAddingNew = (0, _reactRedux.useSelector)(_private_locations.selectAddingNewPrivateLocation);
  const setIsAddingNew = (0, _react.useCallback)(val => dispatch((0, _private_locations.setAddingNewPrivateLocation)(val)), [dispatch]);
  const {
    onSubmit,
    loading,
    privateLocations,
    onDelete,
    deleteLoading
  } = (0, _use_locations_api.usePrivateLocationsAPI)();

  // make sure flyout is closed when first visiting the page
  (0, _react.useEffect)(() => {
    setIsAddingNew(false);
  }, [setIsAddingNew]);
  (0, _react.useEffect)(() => {
    dispatch(_private_locations.getAgentPoliciesAction.get());
    dispatch((0, _state.getServiceLocations)());
  }, [dispatch]);
  const handleSubmit = formData => {
    onSubmit(formData);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loading ? /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, null) : /*#__PURE__*/_react.default.createElement(_manage_empty_state.ManageEmptyState, {
    privateLocations: privateLocations,
    setIsAddingNew: setIsAddingNew
  }, /*#__PURE__*/_react.default.createElement(_locations_table.PrivateLocationsTable, {
    privateLocations: privateLocations,
    onDelete: onDelete,
    deleteLoading: deleteLoading
  })), isAddingNew ? /*#__PURE__*/_react.default.createElement(_add_location_flyout.AddLocationFlyout, {
    setIsOpen: setIsAddingNew,
    onSubmit: handleSubmit,
    privateLocations: privateLocations,
    isLoading: loading
  }) : null);
};
exports.ManagePrivateLocations = ManagePrivateLocations;