"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocationForm = exports.LOCATION_NAME_LABEL = exports.AGENT_MISSING_CALLOUT_TITLE = exports.AGENT_CALLOUT_TITLE = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _tags_field = require("../components/tags_field");
var _agent_policy_needed = require("./agent_policy_needed");
var _policy_hosts = require("./policy_hosts");
var _private_locations = require("../../../state/private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LocationForm = ({
  privateLocations
}) => {
  var _errors$label;
  const {
    data
  } = (0, _reactRedux.useSelector)(_private_locations.selectAgentPolicies);
  const {
    control,
    register,
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const {
    errors
  } = (0, _reactHookForm.useFormState)();
  const selectedPolicyId = getValues(_policy_hosts.AGENT_POLICY_FIELD_NAME);
  const selectedPolicy = data === null || data === void 0 ? void 0 : data.find(item => item.id === selectedPolicyId);
  const tagsList = privateLocations.reduce((acc, item) => {
    const tags = item.tags || [];
    return [...acc, ...tags];
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (data === null || data === void 0 ? void 0 : data.length) === 0 && /*#__PURE__*/_react.default.createElement(_agent_policy_needed.AgentPolicyNeeded, null), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    noValidate: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: LOCATION_NAME_LABEL,
    isInvalid: Boolean(errors === null || errors === void 0 ? void 0 : errors.label),
    error: errors === null || errors === void 0 ? void 0 : (_errors$label = errors.label) === null || _errors$label === void 0 ? void 0 : _errors$label.message
  }, /*#__PURE__*/_react.default.createElement(FieldText, (0, _extends2.default)({
    "data-test-subj": "syntheticsLocationFormFieldText",
    fullWidth: true,
    "aria-label": LOCATION_NAME_LABEL
  }, register('label', {
    required: {
      value: true,
      message: NAME_REQUIRED
    },
    validate: val => {
      return privateLocations.some(loc => loc.label === val) ? NAME_ALREADY_EXISTS : undefined;
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_policy_hosts.PolicyHostsField, {
    privateLocations: privateLocations
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_tags_field.TagsField, {
    tagsList: tagsList,
    control: control,
    errors: errors
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: AGENT_CALLOUT_TITLE,
    size: "s",
    style: {
      textAlign: 'left'
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorManagement.agentCallout.content",
    defaultMessage: "To run \"Browser\" monitors on this private location, make sure that you're using the {code} Docker container, which contains the dependencies necessary to run these monitors. For more information, {link}.",
    values: {
      code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "elastic-agent-complete"),
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsLocationFormReadTheDocsLink",
        target: "_blank",
        href: "https://www.elastic.co/guide/en/observability/current/uptime-set-up-choose-agent.html#private-locations",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.monitorManagement.agentCallout.link",
        defaultMessage: "read the docs"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), (selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.agents) === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: AGENT_MISSING_CALLOUT_TITLE,
    size: "s",
    style: {
      textAlign: 'left'
    },
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorManagement.agentMissingCallout.content",
    defaultMessage: "You have selected an agent policy that has no agent attached. Make sure that you have at least one agent enrolled in this policy. You can add an agent before or after creating a location. For more information, {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsLocationFormReadTheDocsLink",
        target: "_blank",
        href: "https://www.elastic.co/guide/en/observability/current/synthetics-private-location.html#synthetics-private-location-fleet-agent",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.monitorManagement.agentCallout.link",
        defaultMessage: "read the docs"
      }))
    }
  })))));
};
exports.LocationForm = LocationForm;
const FieldText = /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
  "data-test-subj": "syntheticsFieldTextFieldText"
}, props, {
  inputRef: ref
})));
const AGENT_CALLOUT_TITLE = exports.AGENT_CALLOUT_TITLE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.agentCallout.title', {
  defaultMessage: 'Requirement'
});
const AGENT_MISSING_CALLOUT_TITLE = exports.AGENT_MISSING_CALLOUT_TITLE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.agentMissingCallout.title', {
  defaultMessage: 'Selected agent policy has no agents'
});
const LOCATION_NAME_LABEL = exports.LOCATION_NAME_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.locationName', {
  defaultMessage: 'Location name'
});
const NAME_ALREADY_EXISTS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.alreadyExists', {
  defaultMessage: 'Location name already exists.'
});
const NAME_REQUIRED = _i18n.i18n.translate('xpack.synthetics.monitorManagement.nameRequired', {
  defaultMessage: 'Location name is required'
});