"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DslRetentionTab = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _use_get_data_stream_statuses = require("../hooks/use_get_data_stream_statuses");
var _unprivileged = require("./unprivileged");
var _use_management_locator = require("./use_management_locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DslRetentionTab = () => {
  var _body;
  const {
    dataStreamStatuses = [],
    loading,
    error
  } = (0, _use_get_data_stream_statuses.useGetDataStreamStatuses)();
  if (error && ((_body = error.body) === null || _body === void 0 ? void 0 : _body.statusCode) === 403) return /*#__PURE__*/_react.default.createElement(_unprivileged.Unprivileged, {
    hideIlmMessage: true
  });
  if (loading === false && dataStreamStatuses.length === 0) return /*#__PURE__*/_react.default.createElement(ErrorEmptyPrompt, {
    error: error === null || error === void 0 ? void 0 : error.message
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: dataStreamStatuses,
    loading: loading === true,
    columns: DSL_RETENTION_COLUMNS,
    tableLayout: "auto"
  });
};
exports.DslRetentionTab = DslRetentionTab;
const DSL_RETENTION_COLUMNS = [{
  field: 'name',
  name: _i18n.i18n.translate('xpack.synthetics.dslRetention.columns.name', {
    defaultMessage: 'Dataset'
  }),
  render: (name, {
    dataStreamName
  }) => {
    if (!dataStreamName) {
      return name;
    }
    return /*#__PURE__*/_react.default.createElement(DataStreamLink, {
      dataStream: dataStreamName,
      name: name
    });
  }
}, {
  field: 'storageSize',
  name: _i18n.i18n.translate('xpack.synthetics.dslRetention.columns.currentSize', {
    defaultMessage: 'Current size'
  })
}, {
  field: 'lifecycle.data_retention',
  name: _i18n.i18n.translate('xpack.synthetics.dslRetention.columns.retentionPeriod', {
    defaultMessage: 'Retention period'
  })
}, {
  field: 'indexTemplateName',
  name: _i18n.i18n.translate('xpack.synthetics.dslRetention.columns.indexTemplateName', {
    defaultMessage: 'Index template'
  }),
  render: indexTemplateName => /*#__PURE__*/_react.default.createElement(IndexTemplateLabel, {
    indexTemplateName: indexTemplateName
  })
}];
function DataStreamLink({
  dataStream,
  name
}) {
  const templatePath = (0, _use_management_locator.useManagementLocator)(`/data_streams/${dataStream}`);
  if (templatePath === null) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, name);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: templatePath,
    target: "_blank",
    "data-test-subj": `xpack.synthetics.dslRetention.indexTemplateLink.${name}`
  }, name);
}
function IndexTemplateLabel({
  indexTemplateName
}) {
  const templatePath = (0, _use_management_locator.useManagementLocator)(`/templates/${indexTemplateName}`);
  if (templatePath === null) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indexTemplateName);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: templatePath,
    target: "_blank",
    "data-test-subj": `xpack.synthetics.dslRetention.indexTemplateLink.${indexTemplateName}`
  }, indexTemplateName);
}
const ErrorEmptyPrompt = ({
  error
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "error",
  body: error !== null && error !== void 0 ? error : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "p",
    id: "xpack.synthetics.dslRetention.emptyErrorPrompt",
    defaultMessage: "No further error information available"
  }),
  color: "danger",
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "h2",
    id: "xpack.synthetics.dslRetention.noData.heading",
    defaultMessage: "No data retention information found"
  })
});