"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewStatus = OverviewStatus;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _overview_status = require("../../../../state/overview_status");
var _kibana_service = require("../../../../../../utils/kibana_service");
var _use_url_params = require("../../../../hooks/use_url_params");
var _use_overview_status = require("../../hooks/use_overview_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function title(t) {
  return t !== null && t !== void 0 ? t : '-';
}
function OverviewStatus() {
  const {
    statusFilter
  } = (0, _use_url_params.useGetUrlParams)();
  const {
    status,
    error: statusError
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const [statusConfig, setStatusConfig] = (0, _react.useState)({
    up: status === null || status === void 0 ? void 0 : status.up,
    down: status === null || status === void 0 ? void 0 : status.down,
    pending: status === null || status === void 0 ? void 0 : status.pending,
    disabledCount: status === null || status === void 0 ? void 0 : status.disabledCount
  });
  (0, _react.useEffect)(() => {
    if (statusError) {
      dispatch((0, _overview_status.clearOverviewStatusErrorAction)());
      _kibana_service.kibanaService.toasts.addError(statusError.body, {
        title: errorToastTitle,
        toastLifeTimeMs: 5000
      });
    }
  }, [dispatch, statusError]);
  (0, _react.useEffect)(() => {
    if (statusFilter) {
      switch (statusFilter) {
        case 'up':
          setStatusConfig({
            up: (status === null || status === void 0 ? void 0 : status.up) || 0,
            down: 0,
            disabledCount: 0,
            pending: 0
          });
          break;
        case 'down':
          setStatusConfig({
            up: 0,
            down: (status === null || status === void 0 ? void 0 : status.down) || 0,
            disabledCount: 0,
            pending: 0
          });
          break;
        case 'disabled':
          setStatusConfig({
            up: 0,
            down: 0,
            disabledCount: (status === null || status === void 0 ? void 0 : status.disabledCount) || 0,
            pending: 0
          });
          break;
        case 'pending':
          setStatusConfig({
            up: 0,
            down: 0,
            disabledCount: 0,
            pending: (status === null || status === void 0 ? void 0 : status.pending) || 0
          });
          break;
      }
    } else if (status) {
      setStatusConfig({
        up: status.up,
        down: status.down,
        disabledCount: status.disabledCount,
        pending: status === null || status === void 0 ? void 0 : status.pending
      });
    }
  }, [status, statusFilter]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, headingText)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "xpack.uptime.synthetics.overview.status.up",
    description: upDescription,
    reverse: true,
    title: title(statusConfig === null || statusConfig === void 0 ? void 0 : statusConfig.up),
    titleColor: "success",
    titleSize: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "xpack.uptime.synthetics.overview.status.down",
    description: downDescription,
    reverse: true,
    title: title(statusConfig === null || statusConfig === void 0 ? void 0 : statusConfig.down),
    titleColor: "danger",
    titleSize: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "xpack.uptime.synthetics.overview.status.disabled",
    description: disabledDescription,
    reverse: true,
    title: title(statusConfig === null || statusConfig === void 0 ? void 0 : statusConfig.disabledCount),
    titleColor: "subdued",
    titleSize: "m"
  })), ((statusConfig === null || statusConfig === void 0 ? void 0 : statusConfig.pending) || 0) > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "xpack.uptime.synthetics.overview.status.pending",
    description: pendingDescription,
    reverse: true,
    title: title(statusConfig === null || statusConfig === void 0 ? void 0 : statusConfig.pending),
    titleColor: "subdued",
    titleSize: "m"
  }))));
}
const headingText = _i18n.i18n.translate('xpack.synthetics.overview.status.headingText', {
  defaultMessage: 'Current status'
});
const upDescription = _i18n.i18n.translate('xpack.synthetics.overview.status.up.description', {
  defaultMessage: 'Up'
});
const downDescription = _i18n.i18n.translate('xpack.synthetics.overview.status.down.description', {
  defaultMessage: 'Down'
});
const pendingDescription = _i18n.i18n.translate('xpack.synthetics.overview.status.pending.description', {
  defaultMessage: 'Pending'
});
const disabledDescription = _i18n.i18n.translate('xpack.synthetics.overview.status.disabled.description', {
  defaultMessage: 'Disabled'
});
const errorToastTitle = _i18n.i18n.translate('xpack.synthetics.overview.status.error.title', {
  defaultMessage: 'Unable to get monitor status metrics'
});