"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewGridItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _metric_item = require("./metric_item");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewGridItem = ({
  monitor,
  onClick
}) => {
  var _monitor$location;
  const {
    timestamp
  } = (0, _hooks.useStatusByLocationOverview)({
    configId: monitor.configId,
    locationId: monitor.location.id
  });
  const {
    data,
    medianDuration,
    maxDuration,
    avgDuration,
    minDuration
  } = (0, _hooks.useLast50DurationChart)({
    locationId: (_monitor$location = monitor.location) === null || _monitor$location === void 0 ? void 0 : _monitor$location.id,
    monitorId: monitor.id,
    timestamp,
    schedule: monitor.schedule
  });
  return /*#__PURE__*/_react.default.createElement(_metric_item.MetricItem, {
    data: data,
    monitor: monitor,
    medianDuration: medianDuration,
    maxDuration: maxDuration,
    avgDuration: avgDuration,
    minDuration: minDuration,
    onClick: onClick
  });
};
exports.OverviewGridItem = OverviewGridItem;