"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricItemIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _state = require("../../../../state");
var _error_details_link = require("../../../common/links/error_details_link");
var _manual_test_runs = require("../../../../state/manual_test_runs");
var _use_date_format = require("../../../../../../hooks/use_date_format");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _styledComponents.default.div`
  display: inline-block;
  position: absolute;
  right: 10px;
  top: 10px;
  z-index: 1;
`;
const MetricItemIcon = ({
  monitor,
  status,
  ping,
  timestamp,
  configIdByLocation
}) => {
  var _ping$state;
  const testNowRun = (0, _reactRedux.useSelector)((0, _manual_test_runs.manualTestRunSelector)(monitor.configId));
  const isPopoverOpen = (0, _reactRedux.useSelector)(_state.selectErrorPopoverState);
  const dispatch = (0, _reactRedux.useDispatch)();
  const timer = (0, _react.useRef)(null);
  const setIsPopoverOpen = () => {
    dispatch((0, _state.toggleErrorPopoverOpen)(configIdByLocation));
  };
  const inProgress = (0, _manual_test_runs.isTestRunning)(testNowRun);
  const errorLink = (0, _error_details_link.useErrorDetailsLink)({
    configId: monitor.configId,
    stateId: ping === null || ping === void 0 ? void 0 : (_ping$state = ping.state) === null || _ping$state === void 0 ? void 0 : _ping$state.id,
    locationId: monitor.location.id
  });
  const euiShadow = (0, _eui.useEuiShadow)('s');
  const formatter = (0, _use_date_format.useDateFormat)();
  const testTime = formatter(timestamp);
  if (inProgress) {
    return /*#__PURE__*/React.createElement(Container, null, /*#__PURE__*/React.createElement(_eui.EuiToolTip, {
      position: "top",
      content: TEST_IN_PROGRESS
    }, /*#__PURE__*/React.createElement(_eui.EuiLoadingSpinner, null)));
  }
  const closePopover = () => {
    dispatch((0, _state.toggleErrorPopoverOpen)(null));
  };
  if (status === 'down') {
    var _ping$error;
    return /*#__PURE__*/React.createElement(Container, null, /*#__PURE__*/React.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/React.createElement(StyledIcon, {
        onMouseEnter: () => {
          // show popover with delay
          if (timer.current) {
            clearTimeout(timer.current);
          }
          timer.current = setTimeout(() => {
            setIsPopoverOpen();
          }, 300);
        },
        onMouseLeave: () => {
          if (isPopoverOpen) {
            return;
          } else if (timer.current) {
            clearTimeout(timer.current);
          }
        },
        boxShadow: euiShadow,
        onClick: () => {
          if (configIdByLocation === isPopoverOpen) {
            dispatch((0, _state.toggleErrorPopoverOpen)(null));
          } else {
            dispatch((0, _state.toggleErrorPopoverOpen)(configIdByLocation));
          }
        }
      }, /*#__PURE__*/React.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "syntheticsMetricItemIconButton",
        iconType: "warning",
        color: "danger",
        size: "m",
        "aria-label": ERROR_DETAILS
      })),
      isOpen: configIdByLocation === isPopoverOpen,
      closePopover: closePopover,
      anchorPosition: "upCenter",
      panelStyle: {
        outline: 'none'
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
      grow: true
    }, testTime), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "syntheticsMetricItemIconButton",
      iconType: "cross",
      onClick: closePopover
    })))), /*#__PURE__*/React.createElement("div", {
      style: {
        width: '300px'
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
      title: ping === null || ping === void 0 ? void 0 : (_ping$error = ping.error) === null || _ping$error === void 0 ? void 0 : _ping$error.message,
      color: "danger",
      iconType: "warning"
    })), /*#__PURE__*/React.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/React.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsMetricItemIconButton",
      fullWidth: true,
      size: "s",
      href: errorLink
    }, ERROR_DETAILS))));
  } else {
    return null;
  }
};
exports.MetricItemIcon = MetricItemIcon;
const ERROR_DETAILS = _i18n.i18n.translate('xpack.synthetics.errorDetails.label', {
  defaultMessage: 'Error details'
});
const TEST_IN_PROGRESS = _i18n.i18n.translate('xpack.synthetics.inProgress.label', {
  defaultMessage: 'Manual test run is in progress.'
});
const StyledIcon = _common.euiStyled.div`
  box-sizing: border-box;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 10px;
  width: 32px;
  height: 32px;
  background: #ffffff;
  border: 1px solid #d3dae6;
  ${({
  boxShadow
}) => boxShadow}
  border-radius: 16px;
  flex: none;
  order: 0;
  flex-grow: 0;
`;