"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyStateError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyStateError = ({
  errors
}) => {
  const unauthorized = errors.find(error => {
    var _error$body;
    return (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) && error.body.message.includes('unauthorized');
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "securityApp",
    iconColor: "subdued",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, unauthorized ? /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.synthetics.emptyStateError.notAuthorized', {
      defaultMessage: 'You are not authorized to view Uptime data, please contact your system administrator.'
    })) : /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.synthetics.emptyStateError.title', {
      defaultMessage: 'Error'
    }))),
    body: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, !unauthorized && errors.map(error => {
      var _error$body2, _error$body3;
      return /*#__PURE__*/_react.default.createElement("p", {
        key: (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message
      }, (_error$body3 = error.body) === null || _error$body3 === void 0 ? void 0 : _error$body3.message);
    }))
  }))));
};
exports.EmptyStateError = EmptyStateError;