"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorsPageWithServiceAllowed = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _disabled_callout = require("./management/disabled_callout");
var _use_overview_status = require("./hooks/use_overview_status");
var _constants = require("../../../../../common/constants");
var _service_allowed_wrapper = require("../common/wrappers/service_allowed_wrapper");
var _hooks = require("../../hooks");
var _loader = require("./management/loader/loader");
var _use_enablement = require("../../hooks/use_enablement");
var _synthetics_enablement = require("./management/synthetics_enablement/synthetics_enablement");
var _monitor_list_container = require("./management/monitor_list_container");
var _use_breadcrumbs = require("./hooks/use_breadcrumbs");
var _use_monitor_list = require("./hooks/use_monitor_list");
var labels = _interopRequireWildcard(require("./management/labels"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorManagementPage = () => {
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'monitors'
  });
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'monitors',
    delay: 15000
  });
  (0, _use_breadcrumbs.useMonitorListBreadcrumbs)();
  const {
    error: enablementError,
    enablement: {
      isEnabled
    },
    loading: enablementLoading
  } = (0, _use_enablement.useEnablement)();
  (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: false
  });
  const monitorListProps = (0, _use_monitor_list.useMonitorList)();
  const {
    syntheticsMonitors,
    loading: monitorsLoading,
    absoluteTotal,
    loaded
  } = monitorListProps;
  const {
    loading: locationsLoading
  } = (0, _hooks.useLocations)();
  const showEmptyState = isEnabled !== undefined && syntheticsMonitors.length === 0;
  if (isEnabled && !monitorsLoading && absoluteTotal === 0 && loaded) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.GETTING_STARTED_ROUTE
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    loading: enablementLoading || locationsLoading,
    error: Boolean(enablementError),
    loadingTitle: labels.LOADING_LABEL,
    errorTitle: labels.ERROR_HEADING_LABEL,
    errorBody: labels.ERROR_HEADING_BODY
  }, /*#__PURE__*/_react.default.createElement(_disabled_callout.DisabledCallout, {
    total: absoluteTotal
  }), /*#__PURE__*/_react.default.createElement(_monitor_list_container.MonitorListContainer, {
    isEnabled: isEnabled,
    monitorListProps: monitorListProps
  })), showEmptyState && /*#__PURE__*/_react.default.createElement(_synthetics_enablement.EnablementEmptyState, null));
};
const MonitorsPageWithServiceAllowed = exports.MonitorsPageWithServiceAllowed = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_service_allowed_wrapper.ServiceAllowedWrapper, null, /*#__PURE__*/_react.default.createElement(MonitorManagementPage, null)));