"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStats = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var labels = _interopRequireWildcard(require("../labels"));
var _monitor_test_runs = require("./monitor_test_runs");
var _monitor_test_runs_sparkline = require("./monitor_test_runs_sparkline");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorStats = ({
  overviewStatus
}) => {
  var _overviewStatus$allId, _overviewStatus$allId2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "syntheticsManagementSummaryStats",
    css: {
      display: 'flex',
      flexDirection: 'column',
      gap: euiTheme.size.l,
      flexGrow: 1
    },
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, labels.SUMMARY_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      display: 'flex',
      flexDirection: 'row',
      gap: euiTheme.size.l
    }
  }, /*#__PURE__*/_react.default.createElement(MonitorStat, {
    description: labels.CONFIGURATIONS_LABEL,
    value: overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.allMonitorsCount
  }), /*#__PURE__*/_react.default.createElement(MonitorStat, {
    description: labels.DISABLED_LABEL,
    value: overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.disabledMonitorsCount
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: {
      display: 'flex',
      flexDirection: 'column',
      gap: euiTheme.size.l,
      flexGrow: 12,
      minWidth: 260
    },
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, labels.getLastXDaysLabel(30))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      display: 'flex',
      flexDirection: 'row',
      gap: euiTheme.size.l,
      height: '200px'
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_test_runs.MonitorTestRunsCount, {
    monitorIds: (_overviewStatus$allId = overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.allIds) !== null && _overviewStatus$allId !== void 0 ? _overviewStatus$allId : []
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_monitor_test_runs_sparkline.MonitorTestRunsSparkline, {
    monitorIds: (_overviewStatus$allId2 = overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.allIds) !== null && _overviewStatus$allId2 !== void 0 ? _overviewStatus$allId2 : []
  }))))));
};
exports.MonitorStats = MonitorStats;
const EuiStatStyled = (0, _common.euiStyled)(_eui.EuiStat)`
  &&& {
  color: ${({
  theme
}) => theme.eui.euiTitleColor};
    .euiStat__title {
        color: ${({
  theme
}) => theme.eui.euiTitleColor};
        font-size: ${({
  theme
}) => theme.eui.euiFontSizeXL};
    }
  }
`;
const MonitorStat = ({
  description,
  value
}) => {
  var _ref;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const statValue = (_ref = value) !== null && _ref !== void 0 ? _ref : undefined;
  return /*#__PURE__*/_react.default.createElement(EuiStatStyled, {
    description: description,
    isLoading: isNaN(statValue),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      css: {
        fontSize: euiTheme.size.m
      },
      value: statValue
    }),
    reverse: true
  });
};