"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisabledCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var labels = _interopRequireWildcard(require("./labels"));
var _hooks = require("../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DisabledCallout = ({
  total
}) => {
  const {
    enablement,
    invalidApiKeyError,
    loading
  } = (0, _hooks.useEnablement)();
  const showDisableCallout = !enablement.isEnabled && total > 0;
  const showInvalidApiKeyCallout = invalidApiKeyError && total > 0;
  if (!showDisableCallout && !showInvalidApiKeyCallout) {
    return null;
  }
  return !enablement.canEnable && !loading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: labels.CALLOUT_MANAGEMENT_DISABLED,
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, labels.CALLOUT_MANAGEMENT_DESCRIPTION), /*#__PURE__*/_react.default.createElement("p", null, labels.CALLOUT_MANAGEMENT_CONTACT_ADMIN, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMonitorManagementPageLink",
    href: "https://www.elastic.co/guide/en/observability/current/synthetics-get-started-ui.html#uptime-set-up-prereq",
    target: "_blank"
  }, labels.LEARN_MORE_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null;
};
exports.DisabledCallout = DisabledCallout;