"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateMonitorButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_capabilities = require("../../../../hooks/use_capabilities");
var _permissions = require("../common/components/permissions");
var _hooks = require("../../hooks");
var _constants = require("../../../../../common/constants");
var _synthetics_settings_context = require("../../contexts/synthetics_settings_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateMonitorButton = () => {
  const {
    basePath
  } = (0, _react.useContext)(_synthetics_settings_context.SyntheticsSettingsContext);
  const {
    enablement: {
      isEnabled
    }
  } = (0, _hooks.useEnablement)();
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  return /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canEditSynthetics
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    iconSide: "left",
    iconType: "plusInCircleFilled",
    href: `${basePath}/app/synthetics${_constants.MONITOR_ADD_ROUTE}`,
    isDisabled: !isEnabled || !canEditSynthetics,
    "data-test-subj": "syntheticsAddMonitorBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitors.pageHeader.createButton.label",
    defaultMessage: "Create Monitor"
  })));
};
exports.CreateMonitorButton = CreateMonitorButton;