"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelectedMonitor = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _runtime_types = require("../../../../../../common/runtime_types");
var _contexts = require("../../../contexts");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSelectedMonitor = monId => {
  var _error$getPayload;
  let monitorId = monId;
  const {
    monitorId: urlMonitorId
  } = (0, _reactRouterDom.useParams)();
  if (!monitorId) {
    monitorId = urlMonitorId;
  }
  const monitorsList = (0, _reactRedux.useSelector)(_state.selectEncryptedSyntheticsSavedMonitors);
  const {
    loading: monitorListLoading
  } = (0, _reactRedux.useSelector)(_state.selectMonitorListState);
  const refreshInterval = (0, _reactRedux.useSelector)(_state.selectRefreshInterval);
  const monitorFromList = (0, _react.useMemo)(() => {
    var _monitorsList$find;
    return (_monitorsList$find = monitorsList.find(monitor => monitor[_runtime_types.ConfigKey.CONFIG_ID] === monitorId)) !== null && _monitorsList$find !== void 0 ? _monitorsList$find : null;
  }, [monitorId, monitorsList]);
  const error = (0, _reactRedux.useSelector)(_state.selectorError);
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    syntheticsMonitor,
    syntheticsMonitorLoading,
    syntheticsMonitorDispatchedAt
  } = (0, _reactRedux.useSelector)(_state.selectorMonitorDetailsState);
  const dispatch = (0, _reactRedux.useDispatch)();
  const isMonitorFromListValid = monitorId && monitorFromList && monitorFromList[_runtime_types.ConfigKey.CONFIG_ID] === monitorId;
  const isLoadedSyntheticsMonitorValid = monitorId && syntheticsMonitor && syntheticsMonitor[_runtime_types.ConfigKey.CONFIG_ID] === monitorId;
  const availableMonitor = isLoadedSyntheticsMonitorValid ? syntheticsMonitor : isMonitorFromListValid ? monitorFromList : null;
  const isMonitorMissing = (error === null || error === void 0 ? void 0 : error.body.statusCode) === 404 && ((_error$getPayload = error.getPayload) === null || _error$getPayload === void 0 ? void 0 : _error$getPayload.monitorId) === monitorId;
  (0, _react.useEffect)(() => {
    if (monitorId && !availableMonitor && !syntheticsMonitorLoading && !isMonitorMissing) {
      dispatch(_state.getMonitorAction.get({
        monitorId
      }));
    }
  }, [dispatch, monitorId, availableMonitor, syntheticsMonitorLoading, isMonitorMissing]);
  (0, _react.useEffect)(() => {
    // Only perform periodic refresh if the last dispatch was earlier enough
    if (monitorId && !syntheticsMonitorLoading && !monitorListLoading && syntheticsMonitorDispatchedAt > 0 && Date.now() - syntheticsMonitorDispatchedAt > refreshInterval * 1000) {
      dispatch(_state.getMonitorAction.get({
        monitorId
      }));
    }
  }, [dispatch, lastRefresh, refreshInterval, monitorId, monitorListLoading, syntheticsMonitorLoading, syntheticsMonitorDispatchedAt]);
  return {
    monitor: availableMonitor,
    loading: syntheticsMonitorLoading || monitorListLoading,
    error,
    isMonitorMissing
  };
};
exports.useSelectedMonitor = useSelectedMonitor;