"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Uploader = Uploader;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Uploader({
  onUpload
}) {
  const fileReader = (0, _react.useRef)(null);
  const [error, setError] = (0, _react.useState)(null);
  const filePickerRef = (0, _react.useRef)(null);
  const handleFileRead = fileName => {
    var _fileReader$current;
    const content = fileReader === null || fileReader === void 0 ? void 0 : (_fileReader$current = fileReader.current) === null || _fileReader$current === void 0 ? void 0 : _fileReader$current.result;
    if ((content === null || content === void 0 ? void 0 : content.trim().slice(0, 4)) !== 'step') {
      var _filePickerRef$curren;
      setError(PARSING_ERROR);
      (_filePickerRef$curren = filePickerRef.current) === null || _filePickerRef$curren === void 0 ? void 0 : _filePickerRef$curren.removeFiles();
      return;
    }
    onUpload({
      scriptText: content,
      fileName
    });
    setError(null);
  };
  const handleFileChosen = files => {
    if (!files || !files.length) {
      onUpload({
        scriptText: '',
        fileName: ''
      });
      return;
    }
    if (files.length && !files[0].type.includes('javascript')) {
      var _filePickerRef$curren2;
      setError(INVALID_FILE_ERROR);
      (_filePickerRef$curren2 = filePickerRef.current) === null || _filePickerRef$curren2 === void 0 ? void 0 : _filePickerRef$curren2.removeFiles();
      return;
    }
    fileReader.current = new FileReader();
    fileReader.current.onloadend = () => handleFileRead(files[0].name);
    fileReader.current.readAsText(files[0]);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: Boolean(error),
    error: error,
    "aria-label": TESTING_SCRIPT_LABEL,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: "syntheticsFleetScriptRecorderUploader",
    "data-test-subj": "syntheticsFleetScriptRecorderUploader",
    ref: filePickerRef,
    initialPromptText: PROMPT_TEXT,
    onChange: handleFileChosen,
    display: 'large',
    fullWidth: true
  }));
}
const TESTING_SCRIPT_LABEL = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.monitorIntegrationSettingsSection.browser.uploader.fieldLabel', {
  defaultMessage: 'Testing script'
});
const PROMPT_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorConfig.uploader.label', {
  defaultMessage: 'Select or drag and drop a .js file'
});
const INVALID_FILE_ERROR = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.monitorIntegrationSettingsSection.browser.uploader.invalidFileError', {
  defaultMessage: 'Invalid file type. Please upload a .js file generated by the Elastic Synthetics Recorder.'
});
const PARSING_ERROR = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.monitorIntegrationSettingsSection.browser.uploader.parsingError', {
  defaultMessage: 'Error uploading file. Please upload a .js file generated by the Elastic Synthetics Recorder in inline script format.'
});