"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoRefreshButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _client_defaults = require("../../../../../../common/constants/synthetics/client_defaults");
var _hooks = require("../../../hooks");
var _state = require("../../../state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  AUTOREFRESH_INTERVAL_SECONDS,
  AUTOREFRESH_IS_PAUSED
} = _client_defaults.CLIENT_DEFAULTS_SYNTHETICS;
const replaceDefaults = ({
  refreshPaused,
  refreshInterval
}) => {
  return {
    refreshInterval: refreshInterval === AUTOREFRESH_INTERVAL_SECONDS ? undefined : refreshInterval,
    refreshPaused: refreshPaused === AUTOREFRESH_IS_PAUSED ? undefined : refreshPaused
  };
};
const AutoRefreshButton = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const refreshPaused = (0, _reactRedux.useSelector)(_state.selectRefreshPaused);
  const refreshInterval = (0, _reactRedux.useSelector)(_state.selectRefreshInterval);
  const [getUrlsParams, updateUrlParams] = (0, _hooks.useUrlParams)();
  const {
    refreshInterval: urlRefreshInterval,
    refreshPaused: urlIsPaused
  } = getUrlsParams();
  const isFirstRender = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => {
    if (isFirstRender.current) {
      // sync url state with redux state on first render
      dispatch((0, _state.setRefreshIntervalAction)(urlRefreshInterval));
      dispatch((0, _state.setRefreshPausedAction)(urlIsPaused));
      isFirstRender.current = false;
    } else {
      // sync redux state with url state on subsequent renders
      if (urlRefreshInterval !== refreshInterval || urlIsPaused !== refreshPaused) {
        updateUrlParams(replaceDefaults({
          refreshInterval,
          refreshPaused
        }), true);
      }
    }
  }, [updateUrlParams, refreshInterval, refreshPaused, urlRefreshInterval, urlIsPaused, dispatch]);
  const onRefreshChange = newProps => {
    dispatch((0, _state.setRefreshIntervalAction)(newProps.refreshInterval / 1000));
    dispatch((0, _state.setRefreshPausedAction)(newProps.isPaused));
    updateUrlParams(replaceDefaults({
      refreshInterval: newProps.refreshInterval / 1000,
      refreshPaused: newProps.isPaused
    }), true);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAutoRefreshButton, {
    size: "m",
    isPaused: refreshPaused,
    refreshInterval: refreshInterval * 1000,
    onRefreshChange: onRefreshChange,
    shortHand: true
  });
};
exports.AutoRefreshButton = AutoRefreshButton;