"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TLSRuleComponent = void 0;
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _alert_tls = require("./alert_tls");
var _api = require("../../state/settings/api");
var _settings = require("../../state/settings");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TLSRuleComponent = ({
  ruleParams,
  setRuleParams
}) => {
  var _ref, _ruleParams$certAgeTh, _ref2, _ruleParams$certExpir;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    settings
  } = (0, _reactRedux.useSelector)(_settings.selectDynamicSettings);
  (0, _react.useEffect)(() => {
    if (typeof settings === 'undefined') {
      dispatch((0, _api.getDynamicSettings)());
    }
  }, [dispatch, settings]);
  return /*#__PURE__*/_react.default.createElement(_alert_tls.AlertTlsComponent, {
    ageThreshold: (_ref = (_ruleParams$certAgeTh = ruleParams.certAgeThreshold) !== null && _ruleParams$certAgeTh !== void 0 ? _ruleParams$certAgeTh : settings === null || settings === void 0 ? void 0 : settings.certAgeThreshold) !== null && _ref !== void 0 ? _ref : _constants.DYNAMIC_SETTINGS_DEFAULTS.certAgeThreshold,
    expirationThreshold: (_ref2 = (_ruleParams$certExpir = ruleParams.certExpirationThreshold) !== null && _ruleParams$certExpir !== void 0 ? _ruleParams$certExpir : settings === null || settings === void 0 ? void 0 : settings.certExpirationThreshold) !== null && _ref2 !== void 0 ? _ref2 : _constants.DYNAMIC_SETTINGS_DEFAULTS.certExpirationThreshold,
    setAgeThreshold: value => setRuleParams('certAgeThreshold', Number(value)),
    setExpirationThreshold: value => setRuleParams('certExpirationThreshold', Number(value))
  });
};
exports.TLSRuleComponent = TLSRuleComponent;