"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidKuery = exports.AlertQueryBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isValidKuery = query => {
  if (query === '') {
    return true;
  }
  const listOfOperators = [':', '>=', '=>', '>', '<'];
  for (let i = 0; i < listOfOperators.length; i++) {
    const operator = listOfOperators[i];
    const qParts = query.trim().split(operator);
    if (query.includes(operator) && qParts.length > 1 && qParts[1]) {
      return true;
    }
  }
  return false;
};
exports.isValidKuery = isValidKuery;
const AlertQueryBar = ({
  query = '',
  onChange
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    appName,
    dataViews,
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    }
  } = services;
  const [inputVal, setInputVal] = (0, _react.useState)(query);
  const {
    data: dataView
  } = (0, _public2.useFetcher)(async () => {
    return await dataViews.create({
      title: _constants.SYNTHETICS_INDEX_PATTERN
    });
  }, []);
  (0, _react.useEffect)(() => {
    onChange(query);
    setInputVal(query);
  }, [onChange, query]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      flexBasis: 485
    }
  }, /*#__PURE__*/_react.default.createElement(QueryStringInput, {
    indexPatterns: dataView ? [dataView] : [],
    iconType: "search",
    isClearable: true,
    onChange: queryN => {
      setInputVal(queryN === null || queryN === void 0 ? void 0 : queryN.query);
      if (isValidKuery(queryN === null || queryN === void 0 ? void 0 : queryN.query)) {
        // we want to submit when user clears or paste a complete kuery
        onChange(queryN.query);
      }
    },
    onSubmit: queryN => {
      if (queryN) onChange(queryN.query);
    },
    query: {
      query: inputVal,
      language: 'kuery'
    },
    dataTestSubj: "xpack.synthetics.alerts.monitorStatus.filterBar",
    autoSubmit: true,
    disableLanguageSwitcher: true,
    isInvalid: !!(inputVal && !query),
    placeholder: _i18n.i18n.translate('xpack.synthetics.alerts.searchPlaceholder.kql', {
      defaultMessage: 'Filter using kql syntax'
    }),
    appName: appName
  }));
};
exports.AlertQueryBar = AlertQueryBar;