"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.X509Type = exports.X509ExpiryType = exports.UrlType = exports.TlsType = exports.PingsResponseType = exports.PingType = exports.PingStatusesResponseType = exports.PingStatusType = exports.PingStateType = exports.PingHeadersType = exports.PingErrorType = exports.MonitorType = exports.MonitorDetailsType = exports.HttpResponseBodyType = exports.GetPingsParamsType = exports.AgentType = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _observer = require("./observer");
var _error_state = require("./error_state");
var _common = require("../common");
var _synthetics = require("./synthetics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// IO type for validation
const PingErrorType = exports.PingErrorType = t.intersection([t.partial({
  code: t.string,
  id: t.string,
  stack_trace: t.string,
  type: t.string
}), t.type({
  // this is _always_ on the error field
  message: t.string
})]);

// Typescript type for type checking

const MonitorDetailsType = exports.MonitorDetailsType = t.intersection([t.type({
  monitorId: t.string
}), t.partial({
  error: PingErrorType,
  timestamp: t.string,
  alerts: t.unknown
})]);
const HttpResponseBodyType = exports.HttpResponseBodyType = t.partial({
  bytes: t.number,
  content: t.string,
  content_bytes: t.number,
  hash: t.string
});
const ECSDistinguishedName = t.type({
  common_name: t.string,
  distinguished_name: t.string
});
const X509ExpiryType = exports.X509ExpiryType = t.type({
  not_after: t.string,
  not_before: t.string
});
const X509Type = exports.X509Type = t.intersection([t.type({
  issuer: ECSDistinguishedName,
  subject: ECSDistinguishedName,
  serial_number: t.string,
  public_key_algorithm: t.string,
  signature_algorithm: t.string
}), X509ExpiryType, t.partial({
  public_key_curve: t.string,
  public_key_exponent: t.number,
  public_key_size: t.number
})]);
const TlsType = exports.TlsType = t.partial({
  // deprecated in favor of server.x509.not_after/not_before
  certificate_not_valid_after: t.string,
  certificate_not_valid_before: t.string,
  cipher: t.string,
  established: t.boolean,
  server: t.partial({
    hash: t.type({
      sha256: t.string,
      sha1: t.string
    }),
    x509: X509Type
  })
});
const MonitorType = exports.MonitorType = t.intersection([t.type({
  id: t.string,
  status: t.string,
  type: t.string,
  check_group: t.string
}), t.partial({
  duration: t.type({
    us: t.number
  }),
  ip: t.string,
  name: t.string,
  timespan: t.type({
    gte: t.string,
    lt: t.string
  }),
  fleet_managed: t.boolean,
  project: t.type({
    id: t.string,
    name: t.string
  }),
  origin: t.union([t.literal('ui'), t.literal('project')])
})]);
const PingHeadersType = exports.PingHeadersType = t.record(t.string, t.union([t.string, t.array(t.string)]));
const AgentType = exports.AgentType = t.intersection([t.type({
  ephemeral_id: t.string,
  id: t.string,
  type: t.string,
  version: t.string
}), t.partial({
  name: t.string,
  hostname: t.string
})]);

// should this be partial?
const UrlType = exports.UrlType = t.partial({
  domain: t.string,
  full: t.string,
  port: t.number,
  scheme: t.string,
  path: t.string
});
const SummaryCodec = t.type({
  down: t.number,
  up: t.number,
  status: t.union([t.literal('up'), t.literal('down')]),
  attempt: t.number,
  max_attempts: t.number,
  final_attempt: t.boolean,
  retry_group: t.string
});
const PingType = exports.PingType = t.intersection([t.type({
  timestamp: t.string,
  monitor: MonitorType,
  docId: t.string,
  observer: _observer.ObserverCodec
}), t.partial({
  '@timestamp': t.string,
  agent: AgentType,
  container: t.partial({
    id: t.string,
    image: t.partial({
      name: t.string,
      tag: t.string
    }),
    name: t.string,
    runtime: t.string
  }),
  ecs: t.partial({
    version: t.string
  }),
  error: PingErrorType,
  http: t.partial({
    request: t.partial({
      body: t.partial({
        bytes: t.number,
        content: t.partial({
          text: t.string
        })
      }),
      bytes: t.number,
      method: t.string,
      referrer: t.string
    }),
    response: t.partial({
      body: HttpResponseBodyType,
      bytes: t.number,
      redirects: t.array(t.string),
      status_code: t.number,
      headers: PingHeadersType
    }),
    version: t.string
  }),
  icmp: t.partial({
    requests: t.number,
    rtt: t.partial({
      us: t.number
    })
  }),
  kubernetes: t.partial({
    pod: t.partial({
      name: t.string,
      uid: t.string
    })
  }),
  resolve: t.partial({
    ip: t.string,
    rtt: t.partial({
      us: t.number
    })
  }),
  summary: SummaryCodec,
  synthetics: _synthetics.SyntheticsDataType,
  tags: t.array(t.string),
  tcp: t.partial({
    rtt: t.partial({
      connect: t.partial({
        us: t.number
      })
    })
  }),
  tls: TlsType,
  // should this be partial?
  url: UrlType,
  service: t.partial({
    name: t.string
  }),
  config_id: t.string,
  state: _error_state.ErrorStateCodec,
  data_stream: t.interface({
    namespace: t.string,
    type: t.string,
    dataset: t.string
  })
})]);
const PingStateType = exports.PingStateType = t.type({
  timestamp: t.string,
  '@timestamp': t.string,
  monitor: MonitorType,
  docId: t.string,
  state: _error_state.ErrorStateCodec,
  error: PingErrorType
});
const PingStatusType = exports.PingStatusType = t.intersection([t.type({
  timestamp: t.string,
  docId: t.string,
  config_id: t.string,
  locationId: t.string,
  summary: t.partial({
    down: t.number,
    up: t.number
  })
}), t.partial({
  error: PingErrorType
})]);
const PingsResponseType = exports.PingsResponseType = t.type({
  total: t.number,
  pings: t.array(PingType)
});
const PingStatusesResponseType = exports.PingStatusesResponseType = t.type({
  total: t.number,
  pings: t.array(PingStatusType),
  from: t.string,
  to: t.string
});
const GetPingsParamsType = exports.GetPingsParamsType = t.intersection([t.type({
  dateRange: _common.DateRangeType
}), t.partial({
  excludedLocations: t.string,
  index: t.number,
  size: t.number,
  pageIndex: t.number,
  locations: t.string,
  monitorId: t.string,
  sort: t.string,
  status: t.string
})]);