"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewStatusStateCodec = exports.OverviewStatusMetaDataCodec = exports.OverviewStatusCodec = exports.OverviewPingCodec = exports.OverviewPendingStatusMetaDataCodec = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _observer = require("../ping/observer");
var _error_state = require("../ping/error_state");
var _ = require("..");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewPingCodec = exports.OverviewPingCodec = t.intersection([t.interface({
  '@timestamp': t.string,
  summary: t.partial({
    down: t.number,
    up: t.number
  }),
  monitor: _.MonitorType,
  observer: _observer.ObserverCodec,
  config_id: t.string,
  agent: _.AgentType,
  url: _.UrlType,
  state: _error_state.ErrorStateCodec
}), t.partial({
  error: _.PingErrorType
})]);
const OverviewStatusMetaDataCodec = exports.OverviewStatusMetaDataCodec = t.interface({
  monitorQueryId: t.string,
  configId: t.string,
  status: t.string,
  locationId: t.string,
  timestamp: t.string,
  ping: OverviewPingCodec
});
const OverviewPendingStatusMetaDataCodec = exports.OverviewPendingStatusMetaDataCodec = t.intersection([t.interface({
  monitorQueryId: t.string,
  configId: t.string,
  status: t.string,
  location: t.string
}), t.partial({
  timestamp: t.string,
  ping: OverviewPingCodec
})]);
const OverviewStatusCodec = exports.OverviewStatusCodec = t.interface({
  allMonitorsCount: t.number,
  disabledMonitorsCount: t.number,
  projectMonitorsCount: t.number,
  up: t.number,
  down: t.number,
  pending: t.number,
  disabledCount: t.number,
  upConfigs: t.record(t.string, OverviewStatusMetaDataCodec),
  downConfigs: t.record(t.string, OverviewStatusMetaDataCodec),
  pendingConfigs: t.record(t.string, OverviewPendingStatusMetaDataCodec),
  enabledMonitorQueryIds: t.array(t.string),
  disabledMonitorQueryIds: t.array(t.string),
  allIds: t.array(t.string)
});
const OverviewStatusStateCodec = exports.OverviewStatusStateCodec = t.intersection([OverviewStatusCodec, t.interface({
  allConfigs: t.record(t.string, OverviewStatusMetaDataCodec)
})]);