"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isServiceLocationInvalid = exports.ThrottlingOptionsCodec = exports.ServiceLocationsCodec = exports.ServiceLocationsApiResponseCodec = exports.ServiceLocationErrors = exports.ServiceLocationCodec = exports.PublicLocationsCodec = exports.PublicLocationCodec = exports.MonitorServiceLocationsCodec = exports.MonitorServiceLocationCodec = exports.ManifestLocationCodec = exports.LocationsCodec = exports.LocationStatusCodec = exports.LocationStatus = exports.LocationGeoCodec = exports.LocationCodec = exports.DEFAULT_THROTTLING = exports.DEFAULT_BANDWIDTH_LIMIT = exports.BandwidthLimitKeyCodec = exports.BandwidthLimitKey = void 0;
var _Either = require("fp-ts/lib/Either");
var t = _interopRequireWildcard(require("io-ts"));
var _t_enum = require("../../utils/t_enum");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let LocationStatus = exports.LocationStatus = /*#__PURE__*/function (LocationStatus) {
  LocationStatus["GA"] = "ga";
  LocationStatus["BETA"] = "beta";
  LocationStatus["EXPERIMENTAL"] = "experimental";
  return LocationStatus;
}({});
let BandwidthLimitKey = exports.BandwidthLimitKey = /*#__PURE__*/function (BandwidthLimitKey) {
  BandwidthLimitKey["DOWNLOAD"] = "download";
  BandwidthLimitKey["UPLOAD"] = "upload";
  return BandwidthLimitKey;
}({});
const DEFAULT_BANDWIDTH_LIMIT = exports.DEFAULT_BANDWIDTH_LIMIT = {
  [BandwidthLimitKey.DOWNLOAD]: 100,
  [BandwidthLimitKey.UPLOAD]: 30
};
const DEFAULT_THROTTLING = exports.DEFAULT_THROTTLING = {
  [BandwidthLimitKey.DOWNLOAD]: DEFAULT_BANDWIDTH_LIMIT[BandwidthLimitKey.DOWNLOAD],
  [BandwidthLimitKey.UPLOAD]: DEFAULT_BANDWIDTH_LIMIT[BandwidthLimitKey.UPLOAD]
};
const BandwidthLimitKeyCodec = exports.BandwidthLimitKeyCodec = (0, _t_enum.tEnum)('BandwidthLimitKey', BandwidthLimitKey);
const LocationGeoCodec = exports.LocationGeoCodec = t.interface({
  lat: t.union([t.string, t.number, t.null]),
  lon: t.union([t.string, t.number, t.null])
});
const LocationStatusCodec = exports.LocationStatusCodec = (0, _t_enum.tEnum)('LocationStatus', LocationStatus);
const ManifestLocationCodec = exports.ManifestLocationCodec = t.interface({
  url: t.string,
  geo: t.interface({
    name: t.string,
    location: LocationGeoCodec
  }),
  status: LocationStatusCodec
});
const ServiceLocationCodec = exports.ServiceLocationCodec = t.intersection([t.interface({
  id: t.string,
  label: t.string,
  isServiceManaged: t.boolean
}), t.partial({
  url: t.string,
  geo: LocationGeoCodec,
  status: LocationStatusCodec,
  isInvalid: t.boolean
})]);
const PublicLocationCodec = exports.PublicLocationCodec = t.intersection([ServiceLocationCodec, t.interface({
  url: t.string
})]);
const PublicLocationsCodec = exports.PublicLocationsCodec = t.array(PublicLocationCodec);
const MonitorServiceLocationCodec = exports.MonitorServiceLocationCodec = t.intersection([t.interface({
  id: t.string
}), t.partial({
  label: t.string,
  geo: LocationGeoCodec,
  url: t.string,
  isServiceManaged: t.boolean,
  status: t.string
})]);
const ServiceLocationErrors = exports.ServiceLocationErrors = t.array(t.interface({
  locationId: t.string,
  error: t.intersection([t.interface({
    reason: t.string,
    status: t.number
  }), t.partial({
    failed_monitors: t.union([t.array(t.interface({
      id: t.string,
      message: t.string
    })), t.null])
  })])
}));
const ServiceLocationsCodec = exports.ServiceLocationsCodec = t.array(ServiceLocationCodec);
const MonitorServiceLocationsCodec = exports.MonitorServiceLocationsCodec = t.array(MonitorServiceLocationCodec);
const LocationCodec = exports.LocationCodec = t.intersection([ServiceLocationCodec, t.partial({
  isServiceManaged: t.boolean
})]);
const LocationsCodec = exports.LocationsCodec = t.array(LocationCodec);
const isServiceLocationInvalid = location => (0, _Either.isLeft)(MonitorServiceLocationCodec.decode(location));
exports.isServiceLocationInvalid = isServiceLocationInvalid;
const ThrottlingOptionsCodec = exports.ThrottlingOptionsCodec = t.interface({
  [BandwidthLimitKey.DOWNLOAD]: t.number,
  [BandwidthLimitKey.UPLOAD]: t.number
});
const ServiceLocationsApiResponseCodec = exports.ServiceLocationsApiResponseCodec = t.interface({
  throttling: t.union([ThrottlingOptionsCodec, t.undefined]),
  locations: ServiceLocationsCodec
});

// TODO: Remove if not needed
// export type MonitorServiceLocations = t.TypeOf<typeof MonitorServiceLocationsCodec>;
// export type ServiceLocationsApiResponse = t.TypeOf<typeof ServiceLocationsApiResponseCodec>;