"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ServiceNowITOMConnectorTypeId", {
  enumerable: true,
  get: function () {
    return _config.ServiceNowITOMConnectorTypeId;
  }
});
exports.getServiceNowITOMConnectorType = getServiceNowITOMConnectorType;
var _lodash = require("lodash");
var _types = require("@kbn/actions-plugin/common/types");
var _validators = require("../lib/servicenow/validators");
var _schema = require("../lib/servicenow/schema");
var i18n = _interopRequireWildcard(require("../lib/servicenow/translations"));
var _config = require("../lib/servicenow/config");
var _utils = require("../lib/servicenow/utils");
var _service = require("./service");
var _api = require("./api");
var _create_service_wrapper = require("../lib/servicenow/create_service_wrapper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// connector type definition
function getServiceNowITOMConnectorType() {
  return {
    id: _config.ServiceNowITOMConnectorTypeId,
    minimumLicenseRequired: 'platinum',
    name: i18n.SERVICENOW_ITOM,
    supportedFeatureIds: [_types.AlertingConnectorFeatureId, _types.SecurityConnectorFeatureId],
    validate: {
      config: {
        schema: _schema.ExternalIncidentServiceConfigurationBaseSchema,
        customValidator: _validators.validate.config
      },
      secrets: {
        schema: _schema.ExternalIncidentServiceSecretConfigurationSchema,
        customValidator: _validators.validate.secrets
      },
      connector: _validators.validate.connector,
      params: {
        schema: _schema.ExecutorParamsSchemaITOM
      }
    },
    executor: (0, _lodash.curry)(executorITOM)({
      actionTypeId: _config.ServiceNowITOMConnectorTypeId,
      createService: _service.createExternalService,
      api: _api.api
    })
  };
}

// action executor
const supportedSubActionsITOM = ['addEvent', 'getChoices'];
async function executorITOM({
  actionTypeId,
  createService,
  api
}, execOptions) {
  var _data;
  const {
    actionId,
    config,
    params,
    secrets,
    configurationUtilities,
    logger
  } = execOptions;
  const {
    subAction,
    subActionParams
  } = params;
  const connectorTokenClient = execOptions.services.connectorTokenClient;
  const externalServiceConfig = _config.snExternalServiceConfig[actionTypeId];
  let data = null;
  const externalService = (0, _create_service_wrapper.createServiceWrapper)({
    connectorId: actionId,
    credentials: {
      config,
      secrets
    },
    logger,
    configurationUtilities,
    serviceConfig: externalServiceConfig,
    connectorTokenClient,
    createServiceFn: createService
  });
  const apiAsRecord = api;
  (0, _utils.throwIfSubActionIsNotSupported)({
    api: apiAsRecord,
    subAction,
    supportedSubActions: supportedSubActionsITOM,
    logger
  });
  if (subAction === 'addEvent') {
    const eventParams = subActionParams;
    await api.addEvent({
      externalService,
      params: eventParams,
      logger
    });
  }
  if (subAction === 'getChoices') {
    const getChoicesParams = subActionParams;
    data = await api.getChoices({
      externalService,
      params: getChoicesParams,
      logger
    });
  }
  return {
    status: 'ok',
    data: (_data = data) !== null && _data !== void 0 ? _data : {},
    actionId
  };
}