"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SentinelOneConnector = exports.API_PATH = exports.API_MAX_RESULTS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/actions-plugin/server");
var _schema = require("../../../common/sentinelone/schema");
var _constants = require("../../../common/sentinelone/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_MAX_RESULTS = exports.API_MAX_RESULTS = 1000;
const API_PATH = exports.API_PATH = '/web/api/v2.1';
class SentinelOneConnector extends _server.SubActionConnector {
  constructor(params) {
    super(params);
    (0, _defineProperty2.default)(this, "urls", void 0);
    this.urls = {
      isolateHost: `${this.config.url}${API_PATH}/agents/actions/disconnect`,
      releaseHost: `${this.config.url}${API_PATH}/agents/actions/connect`,
      remoteScripts: `${this.config.url}${API_PATH}/remote-scripts`,
      remoteScriptStatus: `${this.config.url}${API_PATH}/remote-scripts/status`,
      remoteScriptsExecute: `${this.config.url}${API_PATH}/remote-scripts/execute`,
      agents: `${this.config.url}${API_PATH}/agents`,
      activities: `${this.config.url}${API_PATH}/activities`
    };
    this.registerSubActions();
  }
  registerSubActions() {
    this.registerSubAction({
      name: _constants.SUB_ACTION.GET_REMOTE_SCRIPTS,
      method: 'getRemoteScripts',
      schema: _schema.SentinelOneGetRemoteScriptsParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.FETCH_AGENT_FILES,
      method: 'fetchAgentFiles',
      schema: _schema.SentinelOneFetchAgentFilesParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.DOWNLOAD_AGENT_FILE,
      method: 'downloadAgentFile',
      schema: _schema.SentinelOneDownloadAgentFileParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.GET_ACTIVITIES,
      method: 'getActivities',
      schema: _schema.SentinelOneGetActivitiesParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.GET_REMOTE_SCRIPT_STATUS,
      method: 'getRemoteScriptStatus',
      schema: _schema.SentinelOneGetRemoteScriptStatusParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.GET_AGENTS,
      method: 'getAgents',
      schema: _schema.SentinelOneGetAgentsParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.ISOLATE_HOST,
      method: 'isolateHost',
      schema: _schema.SentinelOneIsolateHostParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.RELEASE_HOST,
      method: 'releaseHost',
      schema: _schema.SentinelOneIsolateHostParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.EXECUTE_SCRIPT,
      method: 'executeScript',
      schema: _schema.SentinelOneExecuteScriptParamsSchema
    });
  }
  async fetchAgentFiles({
    files,
    agentUUID,
    zipPassCode
  }) {
    var _agent$data$;
    const agent = await this.getAgents({
      uuid: agentUUID
    });
    const agentId = (_agent$data$ = agent.data[0]) === null || _agent$data$ === void 0 ? void 0 : _agent$data$.id;
    if (!agentId) {
      throw new Error(`No agent found in SentinelOne for UUID [${agentUUID}]`);
    }
    return this.sentinelOneApiRequest({
      url: `${this.urls.agents}/${agentId}/actions/fetch-files`,
      method: 'post',
      data: {
        data: {
          password: zipPassCode,
          files
        }
      },
      responseSchema: _schema.SentinelOneFetchAgentFilesResponseSchema
    });
  }
  async downloadAgentFile({
    agentUUID,
    activityId
  }) {
    var _agent$data$2;
    const agent = await this.getAgents({
      uuid: agentUUID
    });
    const agentId = (_agent$data$2 = agent.data[0]) === null || _agent$data$2 === void 0 ? void 0 : _agent$data$2.id;
    if (!agentId) {
      throw new Error(`No agent found in SentinelOne for UUID [${agentUUID}]`);
    }
    return this.sentinelOneApiRequest({
      url: `${this.urls.agents}/${agentId}/uploads/${activityId}`,
      method: 'get',
      responseType: 'stream',
      responseSchema: _schema.SentinelOneDownloadAgentFileResponseSchema
    });
  }
  async getActivities(queryParams) {
    return this.sentinelOneApiRequest({
      url: this.urls.activities,
      method: 'get',
      params: queryParams,
      responseSchema: _schema.SentinelOneGetActivitiesResponseSchema
    });
  }
  async executeScript({
    filter,
    script
  }) {
    if (!filter.ids && !filter.uuids) {
      throw new Error(`A filter must be defined; either 'ids' or 'uuids'`);
    }
    return this.sentinelOneApiRequest({
      url: this.urls.remoteScriptsExecute,
      method: 'post',
      data: {
        data: {
          outputDestination: 'SentinelCloud',
          ...script
        },
        filter
      },
      responseSchema: _schema.SentinelOneExecuteScriptResponseSchema
    });
  }
  async isolateHost({
    alertIds,
    ...payload
  }) {
    const response = await this.getAgents(payload);
    if (response.data.length === 0) {
      const errorMessage = 'No agents found';
      throw new Error(errorMessage);
    }
    if (response.data[0].networkStatus === 'disconnected') {
      const errorMessage = 'Agent already isolated';
      throw new Error(errorMessage);
    }
    const agentId = response.data[0].id;
    return this.sentinelOneApiRequest({
      url: this.urls.isolateHost,
      method: 'post',
      data: {
        filter: {
          ids: agentId
        }
      },
      responseSchema: _schema.SentinelOneIsolateHostResponseSchema
    });
  }
  async releaseHost({
    alertIds,
    ...payload
  }) {
    const response = await this.getAgents(payload);
    if (response.data.length === 0) {
      throw new Error('No agents found');
    }
    if (response.data[0].networkStatus !== 'disconnected') {
      throw new Error('Agent not isolated');
    }
    const agentId = response.data[0].id;
    return this.sentinelOneApiRequest({
      url: this.urls.releaseHost,
      method: 'post',
      data: {
        filter: {
          ids: agentId
        }
      },
      responseSchema: _schema.SentinelOneIsolateHostResponseSchema
    });
  }
  async getAgents(payload) {
    return this.sentinelOneApiRequest({
      url: this.urls.agents,
      params: {
        ...payload
      },
      responseSchema: _schema.SentinelOneGetAgentsResponseSchema
    });
  }
  async getRemoteScriptStatus(payload) {
    return this.sentinelOneApiRequest({
      url: this.urls.remoteScriptStatus,
      params: {
        parent_task_id: payload.parentTaskId
      },
      responseSchema: _schema.SentinelOneGetRemoteScriptStatusResponseSchema
    });
  }
  async sentinelOneApiRequest(req) {
    const response = await this.request({
      ...req,
      params: {
        ...req.params,
        APIToken: this.secrets.token
      }
    });
    return response.data;
  }
  getResponseErrorMessage(error) {
    var _error$response2, _error$response3;
    const appendResponseBody = message => {
      var _error$response$data, _error$response;
      const responseBody = JSON.stringify((_error$response$data = (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.data) !== null && _error$response$data !== void 0 ? _error$response$data : {});
      if (responseBody) {
        return `${message}\nResponse body: ${responseBody}`;
      }
      return message;
    };
    if (!((_error$response2 = error.response) !== null && _error$response2 !== void 0 && _error$response2.status)) {
      var _error$message;
      return appendResponseBody((_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'Unknown API Error');
    }
    if (error.response.status === 401) {
      return appendResponseBody('Unauthorized API Error (401)');
    }
    return appendResponseBody(`API Error: [${(_error$response3 = error.response) === null || _error$response3 === void 0 ? void 0 : _error$response3.statusText}] ${error.message}`);
  }
  async getRemoteScripts(payload) {
    return this.sentinelOneApiRequest({
      url: this.urls.remoteScripts,
      params: {
        limit: API_MAX_RESULTS,
        ...payload
      },
      responseSchema: _schema.SentinelOneGetRemoteScriptsResponseSchema
    });
  }
}
exports.SentinelOneConnector = SentinelOneConnector;