"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVICENOW_SIR_TITLE = exports.SERVICENOW_SIR_DESC = void 0;
exports.getServiceNowSIRConnectorType = getServiceNowSIRConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _helpers = require("../lib/servicenow/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SERVICENOW_SIR_DESC = exports.SERVICENOW_SIR_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowSIR.selectMessageText', {
  defaultMessage: 'Create an incident in ServiceNow SecOps.'
});
const SERVICENOW_SIR_TITLE = exports.SERVICENOW_SIR_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowSIR.connectorTypeTitle', {
  defaultMessage: 'ServiceNow SecOps'
});
function getServiceNowSIRConnectorType() {
  return {
    id: '.servicenow-sir',
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: SERVICENOW_SIR_DESC,
    actionTypeTitle: SERVICENOW_SIR_TITLE,
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../lib/servicenow/servicenow_connectors')))),
    validateParams: async actionParams => {
      var _actionParams$subActi;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('../lib/servicenow/translations')));
      const errors = {
        'subActionParams.incident.short_description': new Array()
      };
      const validationResult = {
        errors
      };
      if (actionParams.subActionParams && actionParams.subActionParams.incident && !((_actionParams$subActi = actionParams.subActionParams.incident.short_description) !== null && _actionParams$subActi !== void 0 && _actionParams$subActi.length)) {
        errors['subActionParams.incident.short_description'].push(translations.TITLE_REQUIRED);
      }
      return validationResult;
    },
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./servicenow_sir_params')))),
    customConnectorSelectItem: {
      getText: _helpers.getConnectorDescriptiveTitle,
      getComponent: _helpers.getSelectedConnectorIcon
    }
  };
}