"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _types = require("./types");
var _use_get_choices = require("../lib/servicenow/use_get_choices");
var _helpers = require("../lib/servicenow/helpers");
var i18n = _interopRequireWildcard(require("../lib/servicenow/translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetChoicesFields = ['urgency', 'severity', 'impact', 'category', 'subcategory'];
const defaultFields = {
  category: [],
  subcategory: [],
  urgency: [],
  severity: [],
  impact: [],
  priority: []
};
const CorrelationIdField = ({
  index,
  messageVariables,
  correlationId,
  editSubActionProperty,
  isRequired,
  errors
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.CORRELATION_ID,
    error: errors['subActionParams.incident.correlation_id'],
    isInvalid: errors['subActionParams.incident.correlation_id'] !== undefined && errors['subActionParams.incident.correlation_id'].length > 0 && !correlationId && isRequired,
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.alerting.serviceNowAction,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackConnectors.components.serviceNow.correlationIDHelpLabel",
      defaultMessage: "Identifier for updating incidents"
    })),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, isRequired ? i18n.REQUIRED_LABEL : i18n.OPTIONAL_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'correlation_id',
    inputTargetValue: correlationId !== null && correlationId !== void 0 ? correlationId : undefined,
    errors: errors['subActionParams.incident.correlation_id']
  }));
};
const eventActionOptions = [{
  value: _types.EventAction.TRIGGER,
  text: i18n.EVENT_ACTION_TRIGGER
}, {
  value: _types.EventAction.RESOLVE,
  text: i18n.EVENT_ACTION_RESOLVE
}];
const ServiceNowParamsFields = props => {
  var _actionConnector$id, _incident$urgency, _incident$severity, _incident$impact, _incident$category, _incident$subcategory, _incident$correlation, _incident$short_descr, _incident$description;
  const {
    executionMode,
    actionConnector,
    actionParams,
    editAction,
    index,
    errors,
    messageVariables,
    selectedActionGroupId
  } = props;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const isDeprecatedActionConnector = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.isDeprecated;
  const [choices, setChoices] = (0, _react.useState)(defaultFields);
  const [eventAction, setEventAction] = (0, _react.useState)(_types.EventAction.TRIGGER);
  const isTestTriggerAction = executionMode === _public.ActionConnectorMode.Test && eventAction === _types.EventAction.TRIGGER;
  const isTestResolveAction = executionMode === _public.ActionConnectorMode.Test && eventAction === _types.EventAction.RESOLVE;
  const actionConnectorRef = (0, _react.useRef)((_actionConnector$id = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id) !== null && _actionConnector$id !== void 0 ? _actionConnector$id : '');
  const showAllIncidentDetails = selectedActionGroupId && selectedActionGroupId !== _helpers.ACTION_GROUP_RECOVERED || isTestTriggerAction;
  const showOnlyCorrelationId = selectedActionGroupId && selectedActionGroupId === _helpers.ACTION_GROUP_RECOVERED || isTestResolveAction;
  if (isTestTriggerAction && !actionParams.subAction) {
    editAction('subAction', 'pushToService', index);
  }
  const {
    incident,
    comments
  } = (0, _react.useMemo)(() => {
    var _actionParams$subActi;
    return (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 ? _actionParams$subActi : {
      incident: {},
      comments: selectedActionGroupId && selectedActionGroupId !== _helpers.ACTION_GROUP_RECOVERED ? [] : undefined
    };
  }, [actionParams.subActionParams, selectedActionGroupId]);
  const editSubActionProperty = (0, _react.useCallback)((key, value) => {
    const newProps = key !== 'comments' ? {
      incident: {
        ...incident,
        [key]: value
      },
      comments
    } : {
      incident,
      [key]: value
    };
    editAction('subActionParams', newProps, index);
  }, [comments, editAction, incident, index]);
  const editComment = (0, _react.useCallback)((key, value) => {
    editSubActionProperty(key, [{
      commentId: '1',
      comment: value
    }]);
  }, [editSubActionProperty]);
  const onChoicesSuccess = (0, _react.useCallback)(values => {
    setChoices(values.reduce((acc, value) => ({
      ...acc,
      [value.element]: [...(acc[value.element] != null ? acc[value.element] : []), value]
    }), defaultFields));
  }, []);
  const categoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.category), [choices.category]);
  const urgencyOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.urgency), [choices.urgency]);
  const severityOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.severity), [choices.severity]);
  const impactOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.impact), [choices.impact]);
  const subcategoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.subcategory.filter(subcategory => subcategory.dependent_value === incident.category)), [choices.subcategory, incident.category]);
  const {
    isLoading: isLoadingChoices
  } = (0, _use_get_choices.useGetChoices)({
    http,
    toastNotifications: toasts,
    actionConnector,
    fields: useGetChoicesFields,
    onSuccess: onChoicesSuccess
  });
  const handleEventActionChange = (0, _react.useCallback)(value => {
    if (!value) {
      return;
    }
    setEventAction(value);
    if (value === _types.EventAction.RESOLVE) {
      editAction('subAction', 'closeIncident', index);
      return;
    }
    editAction('subAction', 'pushToService', index);
  }, [setEventAction, editAction, index]);
  (0, _react.useEffect)(() => {
    var _actionParams$subActi2, _actionParams$subActi3, _actionParams$subActi4;
    if (actionConnector != null && actionConnectorRef.current !== actionConnector.id) {
      actionConnectorRef.current = actionConnector.id;
      if (selectedActionGroupId === _helpers.ACTION_GROUP_RECOVERED) {
        editAction('subActionParams', {
          incident: {
            correlation_id: _helpers.DEFAULT_CORRELATION_ID
          }
        }, index);
        return;
      }
      editAction('subActionParams', {
        incident: {
          correlation_id: _helpers.DEFAULT_CORRELATION_ID
        },
        comments: []
      }, index);
    }
    if ((isTestResolveAction || isTestTriggerAction) && (!(0, _lodash.isEmpty)((_actionParams$subActi2 = actionParams.subActionParams) === null || _actionParams$subActi2 === void 0 ? void 0 : _actionParams$subActi2.incident) || (_actionParams$subActi3 = actionParams.subActionParams) !== null && _actionParams$subActi3 !== void 0 && (_actionParams$subActi4 = _actionParams$subActi3.comments) !== null && _actionParams$subActi4 !== void 0 && _actionParams$subActi4.length)) {
      editAction('subActionParams', {
        incident: {},
        comments: undefined
      }, index);
      return;
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionConnector, isTestResolveAction, isTestTriggerAction]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, executionMode === _public.ActionConnectorMode.Test ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.EVENT_ACTION_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "eventActionSelect",
    options: eventActionOptions,
    value: eventAction,
    onChange: e => handleEventActionChange(e.target.value)
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.INCIDENT)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), showAllIncidentDetails && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.URGENCY_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "urgencySelect",
    hasNoInitialSelection: true,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    options: urgencyOptions,
    value: (_incident$urgency = incident.urgency) !== null && _incident$urgency !== void 0 ? _incident$urgency : '',
    onChange: e => editSubActionProperty('urgency', e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.SEVERITY_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "severitySelect",
    hasNoInitialSelection: true,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    options: severityOptions,
    value: (_incident$severity = incident.severity) !== null && _incident$severity !== void 0 ? _incident$severity : '',
    onChange: e => editSubActionProperty('severity', e.target.value)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.IMPACT_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "impactSelect",
    hasNoInitialSelection: true,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    options: impactOptions,
    value: (_incident$impact = incident.impact) !== null && _incident$impact !== void 0 ? _incident$impact : '',
    onChange: e => editSubActionProperty('impact', e.target.value)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.CATEGORY_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "categorySelect",
    hasNoInitialSelection: true,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    options: categoryOptions,
    value: (_incident$category = incident.category) !== null && _incident$category !== void 0 ? _incident$category : undefined,
    onChange: e => {
      editAction('subActionParams', {
        incident: {
          ...incident,
          category: e.target.value,
          subcategory: null
        },
        comments
      }, index);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, (subcategoryOptions === null || subcategoryOptions === void 0 ? void 0 : subcategoryOptions.length) > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.SUBCATEGORY_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "subcategorySelect",
    hasNoInitialSelection: true,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    options: subcategoryOptions
    // Needs an empty string instead of undefined to select the blank option when changing categories
    ,
    value: (_incident$subcategory = incident.subcategory) !== null && _incident$subcategory !== void 0 ? _incident$subcategory : '',
    onChange: e => editSubActionProperty('subcategory', e.target.value)
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !isDeprecatedActionConnector && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(CorrelationIdField, {
    index: index,
    messageVariables: messageVariables,
    correlationId: incident.correlation_id,
    editSubActionProperty: editSubActionProperty,
    isRequired: showOnlyCorrelationId,
    errors: errors
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.CORRELATION_DISPLAY,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, i18n.OPTIONAL_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'correlation_display',
    inputTargetValue: (_incident$correlation = incident === null || incident === void 0 ? void 0 : incident.correlation_display) !== null && _incident$correlation !== void 0 ? _incident$correlation : undefined
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors['subActionParams.incident.short_description'],
    isInvalid: errors['subActionParams.incident.short_description'] !== undefined && errors['subActionParams.incident.short_description'].length > 0 && incident.short_description !== undefined,
    label: i18n.SHORT_DESCRIPTION_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, i18n.REQUIRED_LABEL)
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'short_description',
    inputTargetValue: (_incident$short_descr = incident === null || incident === void 0 ? void 0 : incident.short_description) !== null && _incident$short_descr !== void 0 ? _incident$short_descr : undefined,
    errors: errors['subActionParams.incident.short_description']
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'description',
    inputTargetValue: (_incident$description = incident.description) !== null && _incident$description !== void 0 ? _incident$description : undefined,
    label: i18n.DESCRIPTION_LABEL
  }), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editComment,
    messageVariables: messageVariables,
    paramsProperty: 'comments',
    inputTargetValue: comments && comments.length > 0 ? comments[0].comment : undefined,
    label: i18n.COMMENTS_LABEL
  })), showOnlyCorrelationId && /*#__PURE__*/_react.default.createElement(CorrelationIdField, {
    index: index,
    messageVariables: messageVariables,
    correlationId: incident.correlation_id,
    editSubActionProperty: editSubActionProperty,
    isRequired: showOnlyCorrelationId,
    errors: errors
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = ServiceNowParamsFields;
module.exports = exports.default;