"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _constants = require("../../../common/openai/constants");
var _constants2 = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  index,
  messageVariables,
  executionMode,
  errors
}) => {
  var _typedActionConnector2;
  const {
    subAction,
    subActionParams
  } = actionParams;
  const {
    body
  } = subActionParams !== null && subActionParams !== void 0 ? subActionParams : {};
  const typedActionConnector = actionConnector;
  const isTest = (0, _react.useMemo)(() => executionMode === _public.ActionConnectorMode.Test, [executionMode]);
  (0, _react.useEffect)(() => {
    if (!subAction) {
      editAction('subAction', isTest ? _constants.SUB_ACTION.TEST : _constants.SUB_ACTION.RUN, index);
    }
  }, [editAction, index, isTest, subAction]);
  (0, _react.useEffect)(() => {
    if (!subActionParams) {
      var _typedActionConnector;
      // default to OpenAiProviderType.OpenAi sample data
      let sampleBody = _constants2.DEFAULT_BODY;
      if ((typedActionConnector === null || typedActionConnector === void 0 ? void 0 : (_typedActionConnector = typedActionConnector.config) === null || _typedActionConnector === void 0 ? void 0 : _typedActionConnector.apiProvider) === _constants.OpenAiProviderType.AzureAi) {
        // update sample data if AzureAi
        sampleBody = _constants2.DEFAULT_BODY_AZURE;
      }
      editAction('subActionParams', {
        body: sampleBody
      }, index);
    }
  }, [typedActionConnector === null || typedActionConnector === void 0 ? void 0 : (_typedActionConnector2 = typedActionConnector.config) === null || _typedActionConnector2 === void 0 ? void 0 : _typedActionConnector2.apiProvider, editAction, index, subActionParams]);
  const editSubActionParams = (0, _react.useCallback)(params => {
    editAction('subActionParams', {
      ...subActionParams,
      ...params
    }, index);
  }, [editAction, index, subActionParams]);
  return /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'body',
    inputTargetValue: body,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.genAi.bodyFieldLabel', {
      defaultMessage: 'Body'
    }),
    ariaLabel: _i18n.i18n.translate('xpack.stackConnectors.components.genAi.bodyCodeEditorAriaLabel', {
      defaultMessage: 'Code editor'
    }),
    errors: errors.body,
    onDocumentsChange: json => {
      editSubActionParams({
        body: json
      });
    },
    onBlur: () => {
      if (!body) {
        editSubActionParams({
          body: ''
        });
      }
    },
    dataTestSubj: "genAi-bodyJsonEditor"
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = ParamsFields;
module.exports = exports.default;