"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidChannelIdSubActionParamsSchema = exports.ValidChannelIdParamsSchema = exports.SlackApiSecretsSchema = exports.SlackApiParamsSchema = exports.SlackApiConfigSchema = exports.PostMessageSubActionParamsSchema = exports.PostMessageParamsSchema = exports.PostBlockkitSubActionParamsSchema = exports.PostBlockkitParamsSchema = void 0;
exports.validateBlockkit = validateBlockkit;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SlackApiSecretsSchema = exports.SlackApiSecretsSchema = _configSchema.schema.object({
  token: _configSchema.schema.string({
    minLength: 1
  })
});
const SlackApiConfigSchema = exports.SlackApiConfigSchema = _configSchema.schema.object({
  allowedChannels: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string({
      minLength: 1
    }),
    name: _configSchema.schema.string({
      minLength: 1
    })
  }), {
    maxSize: 25
  }))
});
const ValidChannelIdSubActionParamsSchema = exports.ValidChannelIdSubActionParamsSchema = _configSchema.schema.object({
  channelId: _configSchema.schema.maybe(_configSchema.schema.string())
});
const ValidChannelIdParamsSchema = exports.ValidChannelIdParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('validChannelId'),
  subActionParams: ValidChannelIdSubActionParamsSchema
});
const PostMessageSubActionParamsSchema = exports.PostMessageSubActionParamsSchema = _configSchema.schema.object({
  channels: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 1
  })),
  channelIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 1
  })),
  text: _configSchema.schema.string({
    minLength: 1
  })
});
function validateBlockkit(text) {
  try {
    const parsedText = JSON.parse(text);
    if (!parsedText.hasOwnProperty('blocks')) {
      return 'block kit body must contain field "blocks"';
    }
  } catch (err) {
    return `block kit body is not valid JSON - ${err.message}`;
  }
}
const PostBlockkitSubActionParamsSchema = exports.PostBlockkitSubActionParamsSchema = _configSchema.schema.object({
  channels: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 1
  })),
  channelIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 1
  })),
  text: _configSchema.schema.string({
    validate: validateBlockkit
  })
});
const PostMessageParamsSchema = exports.PostMessageParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('postMessage'),
  subActionParams: PostMessageSubActionParamsSchema
});
const PostBlockkitParamsSchema = exports.PostBlockkitParamsSchema = _configSchema.schema.object({
  subAction: _configSchema.schema.literal('postBlockkit'),
  subActionParams: PostBlockkitSubActionParamsSchema
});
const SlackApiParamsSchema = exports.SlackApiParamsSchema = _configSchema.schema.oneOf([ValidChannelIdParamsSchema, PostMessageParamsSchema, PostBlockkitParamsSchema]);