"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamingResponseSchema = exports.StreamActionParamsSchema = exports.SecretsSchema = exports.RunActionResponseSchema = exports.RunActionParamsSchema = exports.InvokeAIActionResponseSchema = exports.InvokeAIActionParamsSchema = exports.DashboardActionResponseSchema = exports.DashboardActionParamsSchema = exports.ConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Connector schema
const ConfigSchema = exports.ConfigSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  apiProvider: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.OpenAiProviderType.AzureAi)]),
  apiUrl: _configSchema.schema.string(),
  headers: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string()))
}), _configSchema.schema.object({
  apiProvider: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.OpenAiProviderType.OpenAi)]),
  apiUrl: _configSchema.schema.string(),
  defaultModel: _configSchema.schema.string({
    defaultValue: _constants.DEFAULT_OPENAI_MODEL
  }),
  headers: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string()))
})]);
const SecretsSchema = exports.SecretsSchema = _configSchema.schema.object({
  apiKey: _configSchema.schema.string()
});

// Run action schema
const RunActionParamsSchema = exports.RunActionParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.string(),
  // abort signal from client
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number())
});
const AIMessage = _configSchema.schema.object({
  role: _configSchema.schema.string(),
  content: _configSchema.schema.string(),
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  function_call: _configSchema.schema.maybe(_configSchema.schema.object({
    arguments: _configSchema.schema.string(),
    name: _configSchema.schema.string()
  })),
  tool_calls: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    function: _configSchema.schema.object({
      arguments: _configSchema.schema.string(),
      name: _configSchema.schema.string()
    }),
    type: _configSchema.schema.string()
  }))),
  tool_call_id: _configSchema.schema.maybe(_configSchema.schema.string())
});

// Run action schema
const InvokeAIActionParamsSchema = exports.InvokeAIActionParamsSchema = _configSchema.schema.object({
  messages: _configSchema.schema.arrayOf(AIMessage),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  functions: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    name: _configSchema.schema.string(),
    description: _configSchema.schema.string(),
    parameters: _configSchema.schema.object({
      type: _configSchema.schema.string(),
      properties: _configSchema.schema.object({}, {
        unknowns: 'allow'
      }),
      additionalProperties: _configSchema.schema.boolean(),
      $schema: _configSchema.schema.string()
    }, {
      unknowns: 'allow'
    })
  },
  // Not sure if this will include other properties, we should pass them if it does
  {
    unknowns: 'allow'
  }))),
  function_call: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('none'), _configSchema.schema.literal('auto'), _configSchema.schema.object({
    name: _configSchema.schema.string()
  }, {
    unknowns: 'ignore'
  })])),
  n: _configSchema.schema.maybe(_configSchema.schema.number()),
  stop: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())]))),
  temperature: _configSchema.schema.maybe(_configSchema.schema.number()),
  // abort signal from client
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number())
});
const InvokeAIActionResponseSchema = exports.InvokeAIActionResponseSchema = _configSchema.schema.object({
  message: _configSchema.schema.string(),
  usage: _configSchema.schema.object({
    prompt_tokens: _configSchema.schema.number(),
    completion_tokens: _configSchema.schema.number(),
    total_tokens: _configSchema.schema.number()
  }, {
    unknowns: 'ignore'
  })
});

// Execute action schema
const StreamActionParamsSchema = exports.StreamActionParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.string(),
  stream: _configSchema.schema.boolean({
    defaultValue: false
  }),
  // abort signal from client
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number())
});
const StreamingResponseSchema = exports.StreamingResponseSchema = _configSchema.schema.any();
const RunActionResponseSchema = exports.RunActionResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  object: _configSchema.schema.maybe(_configSchema.schema.string()),
  created: _configSchema.schema.maybe(_configSchema.schema.number()),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  usage: _configSchema.schema.object({
    prompt_tokens: _configSchema.schema.number(),
    completion_tokens: _configSchema.schema.number(),
    total_tokens: _configSchema.schema.number()
  }, {
    unknowns: 'ignore'
  }),
  choices: _configSchema.schema.arrayOf(_configSchema.schema.object({
    message: _configSchema.schema.object({
      role: _configSchema.schema.string(),
      content: _configSchema.schema.maybe(_configSchema.schema.string())
    }, {
      unknowns: 'ignore'
    }),
    finish_reason: _configSchema.schema.maybe(_configSchema.schema.string()),
    index: _configSchema.schema.maybe(_configSchema.schema.number())
  }, {
    unknowns: 'ignore'
  }))
}, {
  unknowns: 'ignore'
});

// Run action schema
const DashboardActionParamsSchema = exports.DashboardActionParamsSchema = _configSchema.schema.object({
  dashboardId: _configSchema.schema.string()
});
const DashboardActionResponseSchema = exports.DashboardActionResponseSchema = _configSchema.schema.object({
  available: _configSchema.schema.boolean()
});