"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamingResponseSchema = exports.SecretsSchema = exports.RunApiLatestResponseSchema = exports.RunActionResponseSchema = exports.RunActionParamsSchema = exports.InvokeAIActionResponseSchema = exports.InvokeAIActionParamsSchema = exports.DashboardActionResponseSchema = exports.DashboardActionParamsSchema = exports.ConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Connector schema
const ConfigSchema = exports.ConfigSchema = _configSchema.schema.object({
  apiUrl: _configSchema.schema.string(),
  defaultModel: _configSchema.schema.string({
    defaultValue: _constants.DEFAULT_BEDROCK_MODEL
  })
});
const SecretsSchema = exports.SecretsSchema = _configSchema.schema.object({
  accessKey: _configSchema.schema.string(),
  secret: _configSchema.schema.string()
});
const RunActionParamsSchema = exports.RunActionParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.string(),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  // abort signal from client
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number())
});
const InvokeAIActionParamsSchema = exports.InvokeAIActionParamsSchema = _configSchema.schema.object({
  messages: _configSchema.schema.arrayOf(_configSchema.schema.object({
    role: _configSchema.schema.string(),
    content: _configSchema.schema.string()
  })),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  temperature: _configSchema.schema.maybe(_configSchema.schema.number()),
  stopSequences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  system: _configSchema.schema.maybe(_configSchema.schema.string()),
  // abort signal from client
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number())
});
const InvokeAIActionResponseSchema = exports.InvokeAIActionResponseSchema = _configSchema.schema.object({
  message: _configSchema.schema.string()
});
const RunApiLatestResponseSchema = exports.RunApiLatestResponseSchema = _configSchema.schema.object({
  stop_reason: _configSchema.schema.maybe(_configSchema.schema.string()),
  usage: _configSchema.schema.object({
    input_tokens: _configSchema.schema.number(),
    output_tokens: _configSchema.schema.number()
  }),
  content: _configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    text: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  }))
}, {
  unknowns: 'allow'
});
const RunActionResponseSchema = exports.RunActionResponseSchema = _configSchema.schema.object({
  completion: _configSchema.schema.string(),
  stop_reason: _configSchema.schema.maybe(_configSchema.schema.string()),
  usage: _configSchema.schema.maybe(_configSchema.schema.object({
    input_tokens: _configSchema.schema.number(),
    output_tokens: _configSchema.schema.number()
  }))
}, {
  unknowns: 'ignore'
});
const StreamingResponseSchema = exports.StreamingResponseSchema = _configSchema.schema.any();

// Run action schema
const DashboardActionParamsSchema = exports.DashboardActionParamsSchema = _configSchema.schema.object({
  dashboardId: _configSchema.schema.string()
});
const DashboardActionResponseSchema = exports.DashboardActionResponseSchema = _configSchema.schema.object({
  available: _configSchema.schema.boolean()
});