"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestQueryRowTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const styles = {
  grid: (0, _react2.css)`
    .euiDataGridHeaderCell {
      background: none;
    }
    .euiDataGridHeader .euiDataGridHeaderCell {
      border-top: none;
    }
  `
};
const TestQueryRowTable = ({
  rawResults,
  alerts
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      overflow: 'hidden'
    },
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    css: styles.grid,
    "aria-label": _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.testQueryTableAriaLabel', {
      defaultMessage: 'Test query grid'
    }),
    "data-test-subj": "test-query-row-datagrid",
    columns: rawResults.cols,
    columnVisibility: {
      visibleColumns: rawResults.cols.map(c => c.id),
      setVisibleColumns: () => {}
    },
    rowCount: rawResults.rows.length,
    gridStyle: {
      border: 'horizontal',
      rowHover: 'none'
    },
    renderCellValue: ({
      rowIndex,
      columnId
    }) => {
      var _rawResults$rows$rowI;
      return (_rawResults$rows$rowI = rawResults.rows[rowIndex][columnId]) !== null && _rawResults$rows$rowI !== void 0 ? _rawResults$rows$rowI : '—';
    },
    pagination: {
      pageIndex: 0,
      pageSize: 10,
      onChangeItemsPerPage: () => {},
      onChangePage: () => {}
    },
    toolbarVisibility: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), alerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.testQueryAlerts', {
    defaultMessage: 'Alerts generated'
  })))), alerts.map((alert, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "alert-badge",
      color: "primary"
    }, alert));
  })));
};
exports.TestQueryRowTable = TestQueryRowTable;