"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceFields = ({
  esFields,
  onChangeSourceFields,
  errors,
  sourceFields
}) => {
  const [sourceFieldsOptions, setSourceFieldsOptions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const options = (0, _lodash.uniqBy)(esFields.filter(f => f.aggregatable).flatMap(f => {
      const validSourceField = _constants.validSourceFields.find(validatedField => f.name === validatedField || f.name === `${validatedField}.keyword`);
      if (validSourceField) {
        return [{
          label: validSourceField,
          value: f.name,
          'data-test-subj': `option-${validSourceField}`
        }];
      }
      return [];
    }), 'label');
    setSourceFieldsOptions(options);

    // if not sourceFields, auto select the current options
    if (!sourceFields) {
      const fields = [];
      options.forEach(f => {
        if (f.value && fields.length < _constants.MAX_SELECTABLE_SOURCE_FIELDS) {
          fields.push({
            label: f.label,
            searchPath: f.value
          });
        }
      });
      onChangeSourceFields(fields);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [esFields]);
  return sourceFieldsOptions.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: errors.length > 0 && sourceFields !== undefined,
    error: errors,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.components.ui.sourceFieldsSelect.title",
      defaultMessage: "Add more fields to alert details"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.components.ui.sourceFieldsSelect.placeholder', {
      defaultMessage: 'Select fields'
    }),
    "data-test-subj": "sourceFields",
    isInvalid: errors.length > 0 && sourceFields !== undefined,
    selectedOptions: (sourceFields || []).map(f => ({
      label: f.label,
      value: f.searchPath,
      'data-test-subj': `option-${f.label}`
    })),
    onChange: options => {
      const fields = [];
      options.forEach(f => {
        if (f.value) {
          fields.push({
            label: f.label,
            searchPath: f.value
          });
        }
      });
      onChangeSourceFields(fields);
    },
    options: sourceFieldsOptions
  })) : null;
};
exports.SourceFields = SourceFields;