"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformDatatableToEsqlTable = exports.toEsQueryHits = exports.rowToDocument = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESQL_DOCUMENT_ID = 'esql_query_document';
const rowToDocument = (columns, row) => {
  return columns.reduce((acc, column, i) => {
    acc[column.name] = row[i];
    return acc;
  }, {});
};
exports.rowToDocument = rowToDocument;
const toEsQueryHits = results => {
  const hits = results.values.map(row => {
    const document = rowToDocument(results.columns, row);
    return {
      _id: ESQL_DOCUMENT_ID,
      _index: '',
      _source: document
    };
  });
  return {
    hits,
    total: hits.length
  };
};
exports.toEsQueryHits = toEsQueryHits;
const transformDatatableToEsqlTable = results => {
  const columns = results.columns.map(c => ({
    name: c.id,
    type: c.meta.type
  }));
  const values = results.rows.map(r => Object.values(r));
  return {
    columns,
    values
  };
};
exports.transformDatatableToEsqlTable = transformDatatableToEsqlTable;