"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LazyWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _suspense_error_boundary = require("../suspense_error_boundary");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LazyWrapper = ({
  fn,
  getStartServices,
  showLoadingSpinner,
  props
}) => {
  const {
    value: startServices = [{
      notifications: undefined
    }]
  } = (0, _useAsync.default)(getStartServices);
  const [{
    notifications
  }] = startServices;
  const LazyComponent = (0, _react.useMemo)(() => /*#__PURE__*/(0, _react.lazy)(() => fn().then(x => ({
    default: x
  }))), [fn]);
  if (!notifications) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_suspense_error_boundary.SuspenseErrorBoundary, {
    notifications: notifications,
    showLoadingSpinner: showLoadingSpinner
  }, /*#__PURE__*/_react.default.createElement(LazyComponent, props));
};
exports.LazyWrapper = LazyWrapper;