"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderSpaceSelectorApp = exports.SpaceSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./space_selector.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxAvatarSolution = require("@kbn/shared-ux-avatar-solution");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _components = require("./components");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SpaceSelector extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "headerRef", void 0);
    (0, _defineProperty2.default)(this, "customBrandingSubscription", void 0);
    (0, _defineProperty2.default)(this, "setHeaderRef", ref => {
      this.headerRef = ref;
      // forcing focus of header for screen readers to announce on page load
      if (this.headerRef) {
        this.headerRef.focus();
      }
    });
    (0, _defineProperty2.default)(this, "getSearchField", () => {
      if (!this.state.spaces || this.state.spaces.length < _constants.SPACE_SEARCH_COUNT_THRESHOLD) {
        return null;
      }
      const inputLabel = _i18n.i18n.translate('xpack.spaces.spaceSelector.findSpacePlaceholder', {
        defaultMessage: 'Find a space'
      });
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        className: "spcSpaceSelector__searchHolder"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
        placeholder: inputLabel,
        "aria-label": inputLabel,
        incremental: true,
        onSearch: this.onSearch
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xl"
      }));
    });
    (0, _defineProperty2.default)(this, "onSearch", (searchTerm = '') => {
      this.setState({
        searchTerm: searchTerm.trim().toLowerCase()
      });
    });
    this.state = {
      loading: false,
      searchTerm: '',
      spaces: []
    };
  }
  componentDidMount() {
    if (this.state.spaces.length === 0) {
      this.loadSpaces();
    }
    this.customBrandingSubscription = this.props.customBranding$.subscribe(next => {
      this.setState({
        ...this.state,
        customLogo: next.logo
      });
    });
  }
  componentWillUnmount() {
    var _this$customBrandingS;
    (_this$customBrandingS = this.customBrandingSubscription) === null || _this$customBrandingS === void 0 ? void 0 : _this$customBrandingS.unsubscribe();
  }
  loadSpaces() {
    this.setState({
      loading: true
    });
    const {
      spacesManager
    } = this.props;
    spacesManager.getSpaces().then(spaces => {
      this.setState({
        loading: false,
        spaces
      });
    }).catch(err => {
      this.setState({
        loading: false,
        error: err
      });
    });
  }
  render() {
    const {
      spaces,
      searchTerm
    } = this.state;
    let filteredSpaces = spaces;
    if (searchTerm) {
      filteredSpaces = spaces.filter(space => space.name.toLowerCase().indexOf(searchTerm) >= 0 || (space.description || '').toLowerCase().indexOf(searchTerm) >= 0);
    }
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
      className: "spcSpaceSelector",
      "data-test-subj": "kibanaSpaceSelector",
      panelled: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "spcSelectorBackground",
      role: "presentation"
    })), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      color: "transparent",
      paddingSize: "xl"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "center",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl"
    }), this.state.customLogo ? /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      src: this.state.customLogo,
      size: 64,
      alt: _i18n.i18n.translate('xpack.spaces.spaceSelector.customLogoAlt', {
        defaultMessage: 'Custom logo'
      })
    }) : /*#__PURE__*/_react.default.createElement(_sharedUxAvatarSolution.KibanaSolutionAvatar, {
      name: "Elastic",
      size: "xl"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("h1", {
      // plain `eui` class undos forced focus style on non-EUI components
      className: "eui spcSpaceSelector__pageHeader",
      tabIndex: 0,
      ref: this.setHeaderRef
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSelector.selectSpacesTitle",
      defaultMessage: "Select your space"
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSelector.changeSpaceAnytimeAvailabilityText",
      defaultMessage: "You can change your space at anytime."
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl"
    }), this.getSearchField(), this.state.loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }), !this.state.loading && /*#__PURE__*/_react.default.createElement(_components.SpaceCards, {
      spaces: filteredSpaces,
      serverBasePath: this.props.serverBasePath
    }), !this.state.loading && !this.state.error && filteredSpaces.length === 0 && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      className: "spcSpaceSelector__errorPanel",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.spaces.spaceSelector.noSpacesMatchSearchCriteriaDescription', {
      defaultMessage: 'No spaces match {searchTerm}',
      values: {
        searchTerm: `"${this.state.searchTerm}"`
      }
    }))))), !this.state.loading && this.state.error && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "danger",
      className: "spcSpaceSelector__errorPanel"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSelector.errorLoadingSpacesDescription",
      defaultMessage: "Error loading spaces ({message})",
      values: {
        message: this.state.error.message
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSelector.contactSysAdminDescription",
      defaultMessage: "Contact your system administrator."
    })))))));
  }
}
exports.SpaceSelector = SpaceSelector;
const renderSpaceSelectorApp = (i18nStart, {
  element,
  theme$
}, props) => {
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(i18nStart.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(SpaceSelector, props))), element);
  return () => _reactDom.default.unmountComponentAtNode(element);
};
exports.renderSpaceSelectorApp = renderSpaceSelectorApp;