"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./spaces_menu.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _manage_spaces_button = require("./manage_spaces_button");
var _common = require("../../../common");
var _space_avatar = require("../../space_avatar");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
class SpacesMenuUI extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "getSpaceOptions", () => {
      return this.props.spaces.map(space => {
        var _this$props$activeSpa;
        return {
          'aria-label': space.name,
          'aria-roledescription': 'space',
          label: space.name,
          key: space.id,
          // id is unique and we need it to form a path later
          prepend: /*#__PURE__*/_react.default.createElement(_react.Suspense, {
            fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
              size: "m"
            })
          }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
            space: space,
            size: 's',
            announceSpaceName: false
          })),
          checked: ((_this$props$activeSpa = this.props.activeSpace) === null || _this$props$activeSpa === void 0 ? void 0 : _this$props$activeSpa.id) === space.id ? 'on' : undefined,
          'data-test-subj': `${space.id}-selectableSpaceItem`,
          className: 'selectableSpaceItem'
        };
      });
    });
    (0, _defineProperty2.default)(this, "spaceSelectionChange", (newOptions, event) => {
      const selectedSpaceItem = newOptions.filter(item => item.checked === 'on')[0];
      if (!!selectedSpaceItem) {
        const urlToSelectedSpace = (0, _common.addSpaceIdToPath)(this.props.serverBasePath, selectedSpaceItem.key,
        // the key is the unique space id
        _common.ENTER_SPACE_PATH);
        let middleClick = false;
        if (event.type === 'click') {
          middleClick = event.button === 1;
        }
        if (event.shiftKey) {
          // Open in new window, shift is given priority over other modifiers
          this.props.toggleSpaceSelector();
          window.open(urlToSelectedSpace);
        } else if (event.ctrlKey || event.metaKey || middleClick) {
          // Open in new tab - either a ctrl click or middle mouse button
          window.open(urlToSelectedSpace, '_blank');
        } else {
          var _this$props$activeSpa2;
          // Force full page reload (usually not a good idea, but we need to in order to change spaces)
          // If the selected space is already the active space, gracefully close the popover
          if (((_this$props$activeSpa2 = this.props.activeSpace) === null || _this$props$activeSpa2 === void 0 ? void 0 : _this$props$activeSpa2.id) === selectedSpaceItem.key) this.props.toggleSpaceSelector();else this.props.navigateToUrl(urlToSelectedSpace);
        }
      }
    });
    (0, _defineProperty2.default)(this, "renderManageButton", () => {
      return /*#__PURE__*/_react.default.createElement(_manage_spaces_button.ManageSpacesButton, {
        key: "manageSpacesButton",
        className: "spcMenu__manageButton",
        size: "s",
        onClick: this.props.toggleSpaceSelector,
        capabilities: this.props.capabilities,
        navigateToApp: this.props.navigateToApp
      });
    });
  }
  render() {
    const spaceOptions = this.getSpaceOptions();
    const noSpacesMessage = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      className: "eui-textCenter"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.navControl.spacesMenu.noSpacesFoundTitle",
      defaultMessage: " no spaces found "
    }));

    // In the future this could be replaced by EuiSelectableSearchableProps, but at this time is is not exported from EUI
    const searchableProps = this.props.spaces.length >= _common.SPACE_SEARCH_COUNT_THRESHOLD ? {
      searchable: true,
      searchProps: {
        placeholder: _i18n.i18n.translate('xpack.spaces.navControl.spacesMenu.findSpacePlaceholder', {
          defaultMessage: 'Find a space'
        }),
        compressed: true,
        isClearable: true,
        id: 'headerSpacesMenuListSearch'
      }
    } : {
      searchable: false
    };
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, (0, _extends2.default)({
      "aria-label": _i18n.i18n.translate('xpack.spaces.navControl.spacesMenu.spacesAriaLabel', {
        defaultMessage: 'Spaces'
      }),
      id: this.props.id,
      className: 'spcMenu',
      title: _i18n.i18n.translate('xpack.spaces.navControl.spacesMenu.changeCurrentSpaceTitle', {
        defaultMessage: 'Change current space'
      })
    }, searchableProps, {
      noMatchesMessage: noSpacesMessage,
      options: spaceOptions,
      singleSelection: 'always',
      style: {
        width: 300
      },
      onChange: this.spaceSelectionChange,
      listProps: {
        rowHeight: 40,
        showIcons: true,
        onFocusBadge: false
      }
    }), (list, search) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      paddingSize: "s"
    }, search || _i18n.i18n.translate('xpack.spaces.navControl.spacesMenu.selectSpacesTitle', {
      defaultMessage: 'Your spaces'
    })), list)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
      paddingSize: "s"
    }, this.renderManageButton()));
  }
}
const SpacesMenu = exports.SpacesMenu = (0, _i18nReact.injectI18n)(SpacesMenuUI);