"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RestoreList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("../../../../../common");
var _shared_imports = require("../../../../shared_imports");
var _constants = require("../../../constants");
var _http = require("../../../services/http");
var _navigation = require("../../../services/navigation");
var _app_context = require("../../../app_context");
var _restore_table = require("./restore_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_SECOND_MS = 1000;
const TEN_SECONDS_MS = 10 * 1000;
const THIRTY_SECONDS_MS = 30 * 1000;
const ONE_MINUTE_MS = 60 * 1000;
const FIVE_MINUTES_MS = 5 * 60 * 1000;
const INTERVAL_OPTIONS = [TEN_SECONDS_MS, THIRTY_SECONDS_MS, ONE_MINUTE_MS, FIVE_MINUTES_MS];
const RestoreList = () => {
  // State for tracking interval picker
  const [isIntervalMenuOpen, setIsIntervalMenuOpen] = (0, _react.useState)(false);
  const [currentInterval, setCurrentInterval] = (0, _react.useState)(INTERVAL_OPTIONS[1]);

  // Load restores
  const {
    error,
    isLoading,
    data: restores = [],
    isInitialRequest,
    resendRequest
  } = (0, _http.useLoadRestores)(currentInterval);
  const {
    uiMetricService,
    history
  } = (0, _app_context.useServices)();
  const {
    core
  } = (0, _app_context.useAppContext)();

  // Track component loaded
  (0, _react.useEffect)(() => {
    uiMetricService.trackUiMetric(_constants.UIM_RESTORE_LIST_LOAD);
  }, [uiMetricService]);
  (0, _shared_imports.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'snapshotRestoreRestoreTab'
  });
  let content;
  if (isInitialRequest) {
    if (isLoading) {
      // Because we're polling for new data, we only want to hide the list during the initial fetch.
      content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.restoreList.loadingRestoresDescription",
        defaultMessage: "Loading restores\u2026"
      }));
    } else if (error) {
      // If we get an error while polling we don't need to show it to the user because they can still
      // work with the table.
      content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.restoreList.loadingRestoresErrorMessage",
          defaultMessage: "Error loading restores"
        }),
        error: error
      });
    }
  } else {
    if (restores && restores.length === 0) {
      content = /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
        iconType: "managementApp",
        title: /*#__PURE__*/_react.default.createElement("h1", {
          "data-test-subj": "noRestoredSnapshotsHeader"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.restoreList.emptyPromptTitle",
          defaultMessage: "No restored snapshots"
        })),
        body: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.restoreList.emptyPromptDescription",
          defaultMessage: "Go to {snapshotsLink} to start a restore.",
          values: {
            snapshotsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToSnapshots)()), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.snapshotRestore.restoreList.emptyPromptDescriptionLink",
              defaultMessage: "Snapshots"
            }))
          }
        }))),
        "data-test-subj": "emptyPrompt"
      });
    } else {
      content = /*#__PURE__*/_react.default.createElement("section", {
        "data-test-subj": "restoreList"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        justifyContent: "flexStart",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        id: "srRestoreListIntervalMenu",
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          size: "xs",
          iconType: "arrowDown",
          iconSide: "right",
          onClick: () => setIsIntervalMenuOpen(!isIntervalMenuOpen)
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.restoreList.intervalMenuButtonText",
          defaultMessage: "Refresh data every {interval}",
          values: {
            interval: currentInterval >= ONE_MINUTE_MS ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.snapshotRestore.restoreList.intervalMenu.minutesIntervalValue",
              defaultMessage: "{minutes} {minutes, plural, one {minute} other {minutes}}",
              values: {
                minutes: Math.ceil(currentInterval / ONE_MINUTE_MS)
              }
            }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.snapshotRestore.restoreList.intervalMenu.secondsIntervalValue",
              defaultMessage: "{seconds} {seconds, plural, one {second} other {seconds}}",
              values: {
                seconds: Math.ceil(currentInterval / ONE_SECOND_MS)
              }
            })
          }
        })),
        isOpen: isIntervalMenuOpen,
        closePopover: () => setIsIntervalMenuOpen(false),
        panelPaddingSize: "none",
        anchorPosition: "downLeft"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
        items: INTERVAL_OPTIONS.map(interval => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: interval,
          icon: "empty",
          onClick: () => {
            resendRequest();
            setCurrentInterval(interval);
            setIsIntervalMenuOpen(false);
          }
        }, interval >= ONE_MINUTE_MS ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.restoreList.intervalMenu.minutesIntervalValue",
          defaultMessage: "{minutes} {minutes, plural, one {minute} other {minutes}}",
          values: {
            minutes: Math.ceil(interval / ONE_MINUTE_MS)
          }
        }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.restoreList.intervalMenu.secondsIntervalValue",
          defaultMessage: "{seconds} {seconds, plural, one {second} other {seconds}}",
          values: {
            seconds: Math.ceil(interval / ONE_SECOND_MS)
          }
        })))
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_restore_table.RestoreTable, {
        restores: restores
      }));
    }
  }
  return /*#__PURE__*/_react.default.createElement(_shared_imports.WithPrivileges, {
    privileges: _common.APP_RESTORE_INDEX_PRIVILEGES.map(name => `index.${name}`)
  }, ({
    hasPrivileges,
    privilegesMissing
  }) => hasPrivileges ? content : /*#__PURE__*/_react.default.createElement(_shared_imports.NotAuthorizedSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreList.deniedPrivilegeTitle",
      defaultMessage: "You're missing index privileges"
    }),
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreList.deniedPrivilegeDescription",
      defaultMessage: "To view snapshot restore status, you must have {privilegesCount, plural, one {this index privilege} other {these index privileges}} for one or more indices: {missingPrivileges}.",
      values: {
        missingPrivileges: privilegesMissing.index.join(', '),
        privilegesCount: privilegesMissing.index.length
      }
    })
  }));
};
exports.RestoreList = RestoreList;