"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDecodedParams = void 0;
var _reactRouterDom = require("react-router-dom");
var _attempt_to_uri_decode = require("./attempt_to_uri_decode");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDecodedParams = () => {
  const params = (0, _reactRouterDom.useParams)();
  const decodedParams = {};
  for (const [key, value] of Object.entries(params)) {
    if (value) {
      decodedParams[key] = (0, _attempt_to_uri_decode.attemptToURIDecode)(value);
    }
  }
  return decodedParams;
};
exports.useDecodedParams = useDecodedParams;