"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryFormStepOne = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("../../../../common");
var _shared_imports = require("../../../shared_imports");
var _http = require("../../services/http");
var _text = require("../../services/text");
var _ = require("..");
var _app_context = require("../../app_context");
var _type_to_doc_url = require("../../lib/type_to_doc_url");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RepositoryFormStepOne = ({
  repository,
  onNext,
  updateRepository,
  validation
}) => {
  // Load repository types
  const {
    error: repositoryTypesError,
    isLoading: repositoryTypesLoading,
    data: repositoryTypes = []
  } = (0, _http.useLoadRepositoryTypes)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const hasValidationErrors = !validation.isValid;
  const onTypeChange = newType => {
    if (repository.type === _common.REPOSITORY_TYPES.source) {
      updateRepository({
        settings: {
          delegateType: newType
        }
      });
    } else {
      updateRepository({
        type: newType,
        settings: {}
      });
    }
  };
  const snapshotRepoDocLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.plugins.snapshotRestoreRepos,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryForm.fields.typePluginsDocLinkText",
    defaultMessage: "Learn more about repository types."
  }));
  const renderNameField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.nameDescriptionTitle",
      defaultMessage: "Repository name"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.nameDescription",
      defaultMessage: "A unique name for the repository."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.nameLabel",
      defaultMessage: "Name"
    }),
    isInvalid: Boolean(hasValidationErrors && validation.errors.name),
    error: validation.errors.name,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: repository.name,
    fullWidth: true,
    onChange: e => {
      updateRepository({
        name: e.target.value
      });
    },
    "data-test-subj": "nameInput"
  })));
  const renderTypeCard = (type, index) => {
    const isSelectedType = (repository.type === _common.REPOSITORY_TYPES.source ? repository.settings.delegateType : repository.type) === type;
    const displayName = _text.textService.getRepositoryTypeName(type);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      title: displayName,
      icon: /*#__PURE__*/_react.default.createElement(_.RepositoryTypeLogo, {
        type: type,
        size: "l"
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.Fragment, null) /* EuiCard requires `description` */,
      footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: (0, _type_to_doc_url.getRepositoryTypeDocUrl)(docLinks, type),
        target: "_blank",
        size: "xs",
        iconType: "iInCircle"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryForm.fields.typeDocsLinkText",
        defaultMessage: "Learn more"
      })),
      selectable: {
        onClick: () => onTypeChange(type),
        isSelected: isSelectedType
      },
      "data-test-subj": `${type}RepositoryType`
    }));
  };
  const renderTypes = () => {
    if (repositoryTypesError) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryForm.loadingRepositoryTypesErrorMessage",
          defaultMessage: "Error loading repository types"
        }),
        error: repositoryTypesError
      });
    }
    if (repositoryTypesLoading) {
      return /*#__PURE__*/_react.default.createElement(_.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryForm.loadingRepositoryTypesDescription",
        defaultMessage: "Loading repository types\u2026"
      }));
    }
    if (!repositoryTypes.length) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryForm.noRepositoryTypesErrorTitle",
          defaultMessage: "No repository types available"
        }),
        color: "warning",
        "data-test-subj": "noRepositoryTypesError"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryForm.noRepositoryTypesErrorMessage",
        defaultMessage: "You can install plugins to enable different repository types. {docLink}",
        values: {
          docLink: snapshotRepoDocLink
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      columns: 4
    }, repositoryTypes.map((type, index) => renderTypeCard(type, index)));
  };
  const renderTypeField = () => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.typeDescriptionTitle",
      defaultMessage: "Repository type"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      id: "repositoryTypeDescription",
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.defaultTypeDescription",
      defaultMessage: "Storage location for your snapshots. {docLink}",
      values: {
        docLink: snapshotRepoDocLink
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      hasEmptyLabelSpace: true,
      describedByIds: ['repositoryTypeDescription'],
      fullWidth: true,
      isInvalid: Boolean(hasValidationErrors && validation.errors.type),
      error: validation.errors.type
    }, renderTypes()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  };
  const renderSourceOnlyToggle = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.sourceOnlyDescriptionTitle",
      defaultMessage: "Source-only snapshots"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.sourceOnlyDescription",
      defaultMessage: "Creates source-only snapshots that take up to 50% less space. {docLink}",
      values: {
        docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: (0, _type_to_doc_url.getRepositoryTypeDocUrl)(docLinks, _common.REPOSITORY_TYPES.source),
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryForm.fields.sourceOnlyDocLinkText",
          defaultMessage: "Learn more about source-only repositories."
        }))
      }
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.fields.sourceOnlyLabel",
      defaultMessage: "Source-only snapshots"
    }),
    checked: repository.type === _common.REPOSITORY_TYPES.source,
    onChange: e => {
      if (e.target.checked) {
        updateRepository({
          type: _common.REPOSITORY_TYPES.source,
          settings: {
            ...repository.settings,
            delegateType: repository.type
          }
        });
      } else {
        const {
          settings: {
            delegateType,
            ...rest
          }
        } = repository;
        updateRepository({
          type: delegateType || null,
          settings: rest
        });
      }
    },
    "data-test-subj": "sourceOnlyToggle"
  })));
  const renderActions = () => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: onNext,
    fill: true,
    iconType: "arrowRight",
    iconSide: "right",
    "data-test-subj": "nextButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryForm.nextButtonLabel",
    defaultMessage: "Next"
  }));
  const renderFormValidationError = () => {
    if (!hasValidationErrors) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryForm.validationErrorTitle",
        defaultMessage: "Fix errors before continuing."
      }),
      color: "danger",
      "data-test-subj": "repositoryFormError"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, renderNameField(), renderTypeField(), renderSourceOnlyToggle(), renderFormValidationError(), renderActions());
};
exports.RepositoryFormStepOne = RepositoryFormStepOne;