"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeslicesBudgetingMethodSchema = exports.targetSchema = exports.tagsSchema = exports.sloIdSchema = exports.sloDefinitionSchema = exports.settingsSchema = exports.optionalSettingsSchema = exports.occurrencesBudgetingMethodSchema = exports.objectiveSchema = exports.groupBySchema = exports.budgetingMethodSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _common = require("./common");
var _duration = require("./duration");
var _indicators = require("./indicators");
var _time_window = require("./time_window");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const occurrencesBudgetingMethodSchema = exports.occurrencesBudgetingMethodSchema = t.literal('occurrences');
const timeslicesBudgetingMethodSchema = exports.timeslicesBudgetingMethodSchema = t.literal('timeslices');
const budgetingMethodSchema = exports.budgetingMethodSchema = t.union([occurrencesBudgetingMethodSchema, timeslicesBudgetingMethodSchema]);
const targetSchema = exports.targetSchema = t.type({
  target: t.number
});
const objectiveSchema = exports.objectiveSchema = t.intersection([targetSchema, t.partial({
  timesliceTarget: t.number,
  timesliceWindow: _duration.durationType
})]);
const settingsSchema = exports.settingsSchema = t.type({
  syncDelay: _duration.durationType,
  frequency: _duration.durationType
});
const groupBySchema = exports.groupBySchema = _common.allOrAnyStringOrArray;
const optionalSettingsSchema = exports.optionalSettingsSchema = t.partial({
  ...settingsSchema.props
});
const tagsSchema = exports.tagsSchema = t.array(t.string);
const sloIdSchema = exports.sloIdSchema = t.string;
const sloDefinitionSchema = exports.sloDefinitionSchema = t.type({
  id: sloIdSchema,
  name: t.string,
  description: t.string,
  indicator: _indicators.indicatorSchema,
  timeWindow: _time_window.timeWindowSchema,
  budgetingMethod: budgetingMethodSchema,
  objective: objectiveSchema,
  settings: settingsSchema,
  revision: t.number,
  enabled: t.boolean,
  tags: tagsSchema,
  createdAt: _common.dateType,
  updatedAt: _common.dateType,
  groupBy: groupBySchema,
  version: t.number
});