"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElasticsearchQueryOrThrow = getElasticsearchQueryOrThrow;
exports.getTimesliceTargetComparator = getTimesliceTargetComparator;
exports.parseIndex = parseIndex;
var _esQuery = require("@kbn/es-query");
var _sloSchema = require("@kbn/slo-schema");
var _errors = require("../../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getElasticsearchQueryOrThrow(kuery = '') {
  try {
    if (_sloSchema.kqlQuerySchema.is(kuery)) {
      return (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(kuery));
    } else {
      return (0, _esQuery.buildEsQuery)(undefined, {
        query: kuery === null || kuery === void 0 ? void 0 : kuery.kqlQuery,
        language: 'kuery'
      }, kuery === null || kuery === void 0 ? void 0 : kuery.filters);
    }
  } catch (err) {
    throw new _errors.InvalidTransformError(`Invalid KQL: ${kuery}`);
  }
}
function parseIndex(index) {
  if (index.indexOf(',') === -1) {
    return index;
  }
  return index.split(',');
}
function getTimesliceTargetComparator(timesliceTarget) {
  return timesliceTarget === 0 ? '>' : '>=';
}