"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.storeSloSettings = exports.getSloSettings = exports.getListOfSummaryIndices = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _sloSchema = require("@kbn/slo-schema");
var _constants = require("../../common/constants");
var _summary_indices = require("../../common/summary_indices");
var _slo_settings = require("../saved_objects/slo_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSloSettings = async soClient => {
  try {
    const soObject = await soClient.get(_slo_settings.SO_SLO_SETTINGS_TYPE, (0, _slo_settings.sloSettingsObjectId)(soClient.getCurrentNamespace()));
    return _sloSchema.sloSettingsSchema.encode(soObject.attributes);
  } catch (e) {
    if (_coreSavedObjectsServer.SavedObjectsErrorHelpers.isNotFoundError(e)) {
      return {
        useAllRemoteClusters: false,
        selectedRemoteClusters: []
      };
    }
    throw e;
  }
};
exports.getSloSettings = getSloSettings;
const storeSloSettings = async (soClient, params) => {
  const object = await soClient.create(_slo_settings.SO_SLO_SETTINGS_TYPE, _sloSchema.sloSettingsSchema.encode(params), {
    id: (0, _slo_settings.sloSettingsObjectId)(soClient.getCurrentNamespace()),
    overwrite: true
  });
  return _sloSchema.sloSettingsSchema.encode(object.attributes);
};
exports.storeSloSettings = storeSloSettings;
const getListOfSummaryIndices = async (soClient, esClient) => {
  const indices = [_constants.SLO_SUMMARY_DESTINATION_INDEX_PATTERN];
  const settings = await getSloSettings(soClient);
  const {
    useAllRemoteClusters,
    selectedRemoteClusters
  } = settings;
  if (!useAllRemoteClusters && selectedRemoteClusters.length === 0) {
    return indices;
  }
  const clustersByName = await esClient.cluster.remoteInfo();
  const clusterNames = clustersByName && Object.keys(clustersByName) || [];
  const clusterInfo = clusterNames.map(clusterName => ({
    name: clusterName,
    isConnected: clustersByName[clusterName].connected
  }));
  return (0, _summary_indices.getListOfSloSummaryIndices)(settings, clusterInfo);
};
exports.getListOfSummaryIndices = getListOfSummaryIndices;