"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FetchHistoricalSummary = void 0;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FetchHistoricalSummary {
  constructor(historicalSummaryClient) {
    this.historicalSummaryClient = historicalSummaryClient;
  }
  async execute(params) {
    const historicalSummary = await this.historicalSummaryClient.fetch(params);
    return _sloSchema.fetchHistoricalSummaryResponseSchema.encode(historicalSummary);
  }
}
exports.FetchHistoricalSummary = FetchHistoricalSummary;