"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reasonActionVariableDescription = exports.alertDetailsUrlActionVariableDescription = void 0;
exports.sloBurnRateRuleType = sloBurnRateRuleType;
exports.viewInAppUrlActionVariableDescription = exports.timestampActionVariableDescription = exports.suppressedActionVariableDescription = exports.sloNameActionVariableDescription = exports.sloInstanceIdActionVariableDescription = exports.sloIdActionVariableDescription = void 0;
var _server = require("@kbn/core/server");
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _slo = require("../../../../common/field_names/slo");
var _constants = require("../../../common/constants");
var _constants2 = require("../../../../common/constants");
var _executor = require("./executor");
var _field_map = require("./field_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const durationSchema = _configSchema.schema.object({
  value: _configSchema.schema.number(),
  unit: _configSchema.schema.string()
});
const windowSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  burnRateThreshold: _configSchema.schema.number(),
  maxBurnRateThreshold: _configSchema.schema.nullable(_configSchema.schema.number()),
  longWindow: durationSchema,
  shortWindow: durationSchema,
  actionGroup: _configSchema.schema.string()
});
const dependency = _configSchema.schema.object({
  ruleId: _configSchema.schema.string(),
  actionGroupsToSuppressOn: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
function sloBurnRateRuleType(basePath, alertsLocator) {
  const paramsSchema = _configSchema.schema.object({
    sloId: _configSchema.schema.string(),
    windows: _configSchema.schema.arrayOf(windowSchema),
    dependencies: _configSchema.schema.maybe(_configSchema.schema.arrayOf(dependency))
  });
  return {
    id: _ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID,
    name: _i18n.i18n.translate('xpack.slo.rules.burnRate.name', {
      defaultMessage: 'SLO burn rate'
    }),
    fieldsForAAD: _slo.SLO_BURN_RATE_AAD_FIELDS,
    validate: {
      params: paramsSchema
    },
    schemas: {
      params: {
        type: 'config-schema',
        schema: paramsSchema
      }
    },
    defaultActionGroupId: _constants2.ALERT_ACTION.id,
    actionGroups: [_constants2.ALERT_ACTION, _constants2.HIGH_PRIORITY_ACTION, _constants2.MEDIUM_PRIORITY_ACTION, _constants2.LOW_PRIORITY_ACTION, _constants2.SUPPRESSED_PRIORITY_ACTION],
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: _common.sloFeatureId,
    minimumLicenseRequired: 'platinum',
    isExportable: true,
    executor: (0, _executor.getRuleExecutor)({
      basePath,
      alertsLocator
    }),
    doesSetRecoveryContext: true,
    actionVariables: {
      context: [{
        name: 'reason',
        description: reasonActionVariableDescription
      }, {
        name: 'timestamp',
        description: timestampActionVariableDescription
      }, {
        name: 'burnRateThreshold',
        description: thresholdActionVariableDescription
      }, {
        name: 'longWindow',
        description: windowActionVariableDescription
      }, {
        name: 'shortWindow',
        description: windowActionVariableDescription
      }, {
        name: 'viewInAppUrl',
        description: viewInAppUrlActionVariableDescription
      }, {
        name: 'alertDetailsUrl',
        description: alertDetailsUrlActionVariableDescription
      }, {
        name: 'sloId',
        description: sloIdActionVariableDescription
      }, {
        name: 'sloName',
        description: sloNameActionVariableDescription
      }, {
        name: 'sloInstanceId',
        description: sloInstanceIdActionVariableDescription
      }, {
        name: 'suppressedAction',
        description: suppressedActionVariableDescription
      }]
    },
    alerts: {
      context: _constants.SLO_RULE_REGISTRATION_CONTEXT,
      mappings: {
        fieldMap: {
          ..._alertsAsDataUtils.legacyExperimentalFieldMap,
          ..._field_map.sloRuleFieldMap
        }
      },
      useEcs: false,
      useLegacyAlerts: true,
      shouldWrite: true
    },
    getViewInAppRelativeUrl: ({
      rule
    }) => _common.observabilityPaths.ruleDetails(rule.id)
  };
}
const thresholdActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.thresholdDescription', {
  defaultMessage: 'The burn rate threshold value.'
});
const windowActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.windowDescription', {
  defaultMessage: 'The window duration with the associated burn rate value.'
});
const reasonActionVariableDescription = exports.reasonActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.reasonDescription', {
  defaultMessage: 'A concise description of the reason for the alert'
});
const timestampActionVariableDescription = exports.timestampActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.timestampDescription', {
  defaultMessage: 'A timestamp of when the alert was detected.'
});
const viewInAppUrlActionVariableDescription = exports.viewInAppUrlActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.viewInAppUrlDescription', {
  defaultMessage: 'The url to the SLO details page to help with further investigation.'
});
const alertDetailsUrlActionVariableDescription = exports.alertDetailsUrlActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.alertDetailsUrlDescription', {
  defaultMessage: 'Link to the alert troubleshooting view for further context and details. This will be an empty string if the server.publicBaseUrl is not configured.'
});
const sloIdActionVariableDescription = exports.sloIdActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.sloIdDescription', {
  defaultMessage: 'The SLO unique identifier.'
});
const sloNameActionVariableDescription = exports.sloNameActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.sloNameDescription', {
  defaultMessage: 'The SLO name.'
});
const sloInstanceIdActionVariableDescription = exports.sloInstanceIdActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.sloInstanceIdDescription', {
  defaultMessage: 'The SLO instance id.'
});
const suppressedActionVariableDescription = exports.suppressedActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.suppressedActionDescription', {
  defaultMessage: 'The suppressed action group.'
});