"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.render = exports.data = exports.core = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _react2 = require("@testing-library/react");
var _mocks = require("@kbn/core/public/mocks");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _jaJP = _interopRequireDefault(require("@kbn/translations-plugin/translations/ja-JP.json"));
var _common = require("@kbn/kibana-react-plugin/common");
var _mocks2 = require("@kbn/data-plugin/public/mocks");
var _public2 = require("@kbn/observability-plugin/public");
var _plugin_context = require("../context/plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const appMountParameters = {
  setHeaderActionMenu: () => {}
};
const observabilityRuleTypeRegistry = (0, _public2.createObservabilityRuleTypeRegistryMock)();
const core = exports.core = _mocks.coreMock.createStart();
const data = exports.data = _mocks2.dataPluginMock.createStartContract();
const queryClient = new _reactQuery.QueryClient({
  defaultOptions: {
    queries: {
      retry: false
    }
  },
  logger: {
    // eslint-disable-next-line no-console
    log: console.log,
    // eslint-disable-next-line no-console
    warn: console.warn,
    error: () => {}
  }
});
const render = component => {
  return (0, _react2.render)(
  /*#__PURE__*/
  // @ts-ignore
  _react.default.createElement(_i18nReact.__IntlProvider, {
    locale: "en-US",
    messages: _jaJP.default.messages
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      data,
      exploratoryView: {
        createExploratoryViewUrl: jest.fn(),
        getAppDataView: jest.fn(),
        // eslint-disable-next-line @kbn/i18n/strings_should_be_translated_with_i18n
        ExploratoryViewEmbeddable: () => /*#__PURE__*/_react.default.createElement("div", null, "Embeddable exploratory view")
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
    value: {
      appMountParameters,
      observabilityRuleTypeRegistry,
      ObservabilityPageTemplate: _sharedUxPageKibanaTemplate.KibanaPageTemplate
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, null, component))))));
};
exports.render = render;