"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiscoverLink = getDiscoverLink;
exports.openInDiscover = openInDiscover;
var _sloSchema = require("@kbn/slo-schema");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-plugin/public");
var _uuid = require("uuid");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createDiscoverLocator(slo, showBad = false, showGood = false, timeRange) {
  const indexId = (0, _uuid.v4)();
  const filters = [];
  if (_sloSchema.kqlWithFiltersSchema.is(slo.indicator.params.filter)) {
    slo.indicator.params.filter.filters.forEach(i => filters.push(i));
  }
  const filterKuery = _sloSchema.kqlWithFiltersSchema.is(slo.indicator.params.filter) ? slo.indicator.params.filter.kqlQuery : slo.indicator.params.filter;
  if (slo.indicator.type === 'sli.kql.custom') {
    const goodKuery = _sloSchema.kqlWithFiltersSchema.is(slo.indicator.params.good) ? slo.indicator.params.good.kqlQuery : slo.indicator.params.good;
    const goodFilters = _sloSchema.kqlWithFiltersSchema.is(slo.indicator.params.good) ? slo.indicator.params.good.filters : [];
    const totalKuery = _sloSchema.kqlWithFiltersSchema.is(slo.indicator.params.total) ? slo.indicator.params.total.kqlQuery : slo.indicator.params.total;
    const totalFilters = _sloSchema.kqlWithFiltersSchema.is(slo.indicator.params.total) ? slo.indicator.params.total.filters : [];
    const customGoodFilter = (0, _public.buildEsQuery)({
      kuery: goodKuery,
      filters: goodFilters
    });
    const customTotalFilter = (0, _public.buildEsQuery)({
      kuery: totalKuery,
      filters: totalFilters
    });
    const customBadFilter = {
      bool: {
        filter: customTotalFilter,
        must_not: customGoodFilter
      }
    };
    filters.push({
      $state: {
        store: _esQuery.FilterStateStore.APP_STATE
      },
      meta: {
        type: 'custom',
        alias: _i18n.i18n.translate('xpack.slo.sloDetails.goodFilterLabel', {
          defaultMessage: 'Good events'
        }),
        disabled: !showGood,
        value: JSON.stringify(customGoodFilter),
        index: indexId
      },
      query: customGoodFilter
    });
    filters.push({
      $state: {
        store: _esQuery.FilterStateStore.APP_STATE
      },
      meta: {
        type: 'custom',
        alias: _i18n.i18n.translate('xpack.slo.sloDetails.badFilterLabel', {
          defaultMessage: 'Bad events'
        }),
        disabled: !showBad,
        value: JSON.stringify(customBadFilter),
        index: indexId
      },
      query: customBadFilter
    });
    filters.push({
      $state: {
        store: _esQuery.FilterStateStore.APP_STATE
      },
      meta: {
        type: 'custom',
        alias: _i18n.i18n.translate('xpack.slo.sloDetails.totalFilterLabel', {
          defaultMessage: 'Total events'
        }),
        value: JSON.stringify(customTotalFilter),
        index: indexId
      },
      query: customTotalFilter
    });
  }
  const groupBy = [slo.groupBy].flat();
  if (!(0, _lodash.isEmpty)(slo.groupings) && groupBy.length > 0 && groupBy.every(field => field === _sloSchema.ALL_VALUE) === false) {
    groupBy.forEach(field => {
      filters.push({
        meta: {
          disabled: false,
          negate: false,
          alias: null,
          key: field,
          params: {
            query: slo.groupings[field]
          },
          type: 'phrase',
          index: indexId
        },
        $state: {
          store: _esQuery.FilterStateStore.APP_STATE
        },
        query: {
          match_phrase: {
            [field]: slo.groupings[field]
          }
        }
      });
    });
  }
  const timeFieldName = slo.indicator.type !== 'sli.apm.transactionDuration' && slo.indicator.type !== 'sli.apm.transactionErrorRate' && slo.indicator.type !== 'sli.synthetics.availability' ? slo.indicator.params.timestampField : '@timestamp';
  return {
    timeRange,
    query: {
      query: filterKuery || '',
      language: 'kuery'
    },
    filters,
    dataViewSpec: {
      id: indexId,
      title: slo.remote ? `${slo.remote.remoteName}:${slo.indicator.params.index}` : slo.indicator.params.index,
      timeFieldName
    }
  };
}
function getDiscoverLink(discover, slo, timeRange) {
  var _discover$locator;
  const config = createDiscoverLocator(slo, false, false, timeRange);
  return discover === null || discover === void 0 ? void 0 : (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.getRedirectUrl(config);
}
function openInDiscover(discover, slo, showBad = false, showGood = false, timeRange) {
  var _discover$locator2;
  const config = createDiscoverLocator(slo, showBad, showGood, timeRange);
  discover === null || discover === void 0 ? void 0 : (_discover$locator2 = discover.locator) === null || _discover$locator2 === void 0 ? void 0 : _discover$locator2.navigate(config);
}