"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_SLO_ALERTS_ACTION = void 0;
exports.createEditSloAlertsPanelAction = createEditSloAlertsPanelAction;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/embeddable-plugin/common");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _constants = require("../embeddable/slo/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EDIT_SLO_ALERTS_ACTION = exports.EDIT_SLO_ALERTS_ACTION = 'editSloAlertsPanelAction';
const isEditSloAlertsPanelApi = api => Boolean((0, _presentationPublishing.apiHasType)(api) && (0, _presentationPublishing.apiIsOfType)(api, _constants.SLO_ALERTS_EMBEDDABLE) && (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.getInheritedViewMode)(api) === _common.ViewMode.EDIT);
function createEditSloAlertsPanelAction(getStartServices) {
  return (0, _public.createAction)({
    id: EDIT_SLO_ALERTS_ACTION,
    type: EDIT_SLO_ALERTS_ACTION,
    getIconType() {
      return 'pencil';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.slo.actions.editSloAlertsEmbeddableTitle', {
      defaultMessage: 'Edit configuration'
    }),
    async execute({
      embeddable
    }) {
      if (!embeddable) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      const [coreStart, pluginStart] = await getStartServices();
      try {
        const {
          resolveEmbeddableSloUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddable/slo/alerts/handle_explicit_input')));
        const result = await resolveEmbeddableSloUserInput(coreStart, pluginStart, embeddable.getSloAlertsConfig());
        embeddable.updateInput(result);
      } catch (e) {
        return Promise.reject();
      }
    },
    isCompatible: async ({
      embeddable
    }) => isEditSloAlertsPanelApi(embeddable)
  });
}