"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRoutes = void 0;
var _react = _interopRequireDefault(require("react"));
var _slos = require("../pages/slos/slos");
var _slos_welcome = require("../pages/slos_welcome/slos_welcome");
var _slo_details = require("../pages/slo_details/slo_details");
var _slo_edit = require("../pages/slo_edit/slo_edit");
var _paths = require("../../common/locators/paths");
var _slo_outdated_definitions = require("../pages/slo_outdated_definitions");
var _slo_settings = require("../pages/slo_settings/slo_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRoutes = isServerless => {
  return {
    [_paths.SLOS_PATH]: {
      handler: () => {
        return /*#__PURE__*/_react.default.createElement(_slos.SlosPage, null);
      },
      params: {},
      exact: true
    },
    [_paths.SLO_CREATE_PATH]: {
      handler: () => {
        return /*#__PURE__*/_react.default.createElement(_slo_edit.SloEditPage, null);
      },
      params: {},
      exact: true
    },
    [_paths.SLOS_WELCOME_PATH]: {
      handler: () => {
        return /*#__PURE__*/_react.default.createElement(_slos_welcome.SlosWelcomePage, null);
      },
      params: {},
      exact: true
    },
    [_paths.SLOS_OUTDATED_DEFINITIONS_PATH]: {
      handler: () => {
        return /*#__PURE__*/_react.default.createElement(_slo_outdated_definitions.SlosOutdatedDefinitions, null);
      },
      params: {},
      exact: true
    },
    [_paths.SLO_EDIT_PATH]: {
      handler: () => {
        return /*#__PURE__*/_react.default.createElement(_slo_edit.SloEditPage, null);
      },
      params: {},
      exact: true
    },
    ...(!isServerless ? {
      [_paths.SLO_SETTINGS_PATH]: {
        handler: () => {
          return /*#__PURE__*/_react.default.createElement(_slo_settings.SloSettingsPage, null);
        },
        params: {},
        exact: true
      }
    } : {}),
    [_paths.SLO_DETAIL_PATH]: {
      handler: () => {
        return /*#__PURE__*/_react.default.createElement(_slo_details.SloDetailsPage, null);
      },
      params: {},
      exact: true
    }
  };
};
exports.getRoutes = getRoutes;