"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _rxjs = require("rxjs");
var _common = require("../common");
var _slo_details = require("./locators/slo_details");
var _slo_edit = require("./locators/slo_edit");
var _slo_list = require("./locators/slo_list");
var _paths = require("../common/locators/paths");
var _get_create_slo_flyout = require("./pages/slo_edit/shared_flyout/get_create_slo_flyout");
var _register_burn_rate_rule_type = require("./rules/register_burn_rate_rule_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SloPlugin {
  constructor(initContext) {
    var _this$initContext$con;
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "experimentalFeatures", {
      ruleFormV2: {
        enabled: false
      }
    });
    this.initContext = initContext;
    this.experimentalFeatures = (_this$initContext$con = this.initContext.config.get().experimental) !== null && _this$initContext$con !== void 0 ? _this$initContext$con : this.experimentalFeatures;
  }
  setup(coreSetup, pluginsSetup) {
    const kibanaVersion = this.initContext.env.packageInfo.version;
    const sloDetailsLocator = pluginsSetup.share.url.locators.create(new _slo_details.SloDetailsLocatorDefinition());
    const sloEditLocator = pluginsSetup.share.url.locators.create(new _slo_edit.SloEditLocatorDefinition());
    const sloListLocator = pluginsSetup.share.url.locators.create(new _slo_list.SloListLocatorDefinition());
    const mount = async params => {
      const {
        renderApp
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
      const [coreStart, pluginsStart] = await coreSetup.getStartServices();
      const {
        ruleTypeRegistry,
        actionTypeRegistry
      } = pluginsStart.triggersActionsUi;
      const {
        observabilityRuleTypeRegistry
      } = pluginsStart.observability;
      return renderApp({
        appMountParameters: params,
        core: coreStart,
        isDev: this.initContext.env.mode.dev,
        observabilityRuleTypeRegistry,
        kibanaVersion,
        usageCollection: pluginsSetup.usageCollection,
        ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
        plugins: {
          ...pluginsStart,
          ruleTypeRegistry,
          actionTypeRegistry
        },
        isServerless: !!pluginsStart.serverless,
        experimentalFeatures: this.experimentalFeatures
      });
    };
    const appUpdater$ = this.appUpdater$;
    const app = {
      id: _common.sloAppId,
      title: _common.PLUGIN_NAME,
      order: 8002,
      updater$: appUpdater$,
      euiIconType: 'logoObservability',
      appRoute: _paths.SLOS_BASE_PATH,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      mount,
      keywords: ['observability', 'monitor', 'slos']
    };
    // Register an application into the side navigation menu
    coreSetup.application.register(app);
    (0, _register_burn_rate_rule_type.registerBurnRateRuleType)(pluginsSetup.observability.observabilityRuleTypeRegistry);
    const assertPlatinumLicense = async () => {
      const licensing = await pluginsSetup.licensing;
      const license = await (0, _rxjs.firstValueFrom)(licensing.license$);
      const hasPlatinumLicense = license.hasAtLeast('platinum');
      if (hasPlatinumLicense) {
        const registerSloOverviewEmbeddableFactory = async () => {
          const {
            SloOverviewEmbeddableFactoryDefinition
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/slo/overview/slo_embeddable_factory')));
          const factory = new SloOverviewEmbeddableFactoryDefinition(coreSetup.getStartServices);
          pluginsSetup.embeddable.registerEmbeddableFactory(factory.type, factory);
        };
        registerSloOverviewEmbeddableFactory();
        const registerSloAlertsEmbeddableFactory = async () => {
          const {
            SloAlertsEmbeddableFactoryDefinition
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/slo/alerts/slo_alerts_embeddable_factory')));
          const factory = new SloAlertsEmbeddableFactoryDefinition(coreSetup.getStartServices, kibanaVersion);
          pluginsSetup.embeddable.registerEmbeddableFactory(factory.type, factory);
        };
        registerSloAlertsEmbeddableFactory();
        const registerSloErrorBudgetEmbeddableFactory = async () => {
          const {
            SloErrorBudgetEmbeddableFactoryDefinition
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/slo/error_budget/slo_error_budget_embeddable_factory')));
          const factory = new SloErrorBudgetEmbeddableFactoryDefinition(coreSetup.getStartServices);
          pluginsSetup.embeddable.registerEmbeddableFactory(factory.type, factory);
        };
        registerSloErrorBudgetEmbeddableFactory();
        const registerAsyncSloAlertsUiActions = async () => {
          if (pluginsSetup.uiActions) {
            const {
              registerSloAlertsUiActions
            } = await Promise.resolve().then(() => _interopRequireWildcard(require('./ui_actions')));
            registerSloAlertsUiActions(pluginsSetup.uiActions, coreSetup);
          }
        };
        registerAsyncSloAlertsUiActions();
      }
    };
    assertPlatinumLicense();
    return {
      sloDetailsLocator,
      sloEditLocator,
      sloListLocator
    };
  }
  start(coreStart, pluginsStart) {
    const kibanaVersion = this.initContext.env.packageInfo.version;
    const {
      ruleTypeRegistry,
      actionTypeRegistry
    } = pluginsStart.triggersActionsUi;
    return {
      getCreateSLOFlyout: (0, _get_create_slo_flyout.getCreateSLOFlyoutLazy)({
        core: coreStart,
        isDev: this.initContext.env.mode.dev,
        kibanaVersion,
        observabilityRuleTypeRegistry: pluginsStart.observability.observabilityRuleTypeRegistry,
        ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
        plugins: {
          ...pluginsStart,
          ruleTypeRegistry,
          actionTypeRegistry
        },
        isServerless: !!pluginsStart.serverless,
        experimentalFeatures: this.experimentalFeatures
      })
    };
  }
  stop() {}
}
exports.SloPlugin = SloPlugin;