"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSloFormattedSummary = exports.useSloFormattedSLIValue = exports.getSloFormattedSummary = void 0;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _sloSchema = require("@kbn/slo-schema");
var _kibana_react = require("../../../utils/kibana_react");
var _paths = require("../../../../common/locators/paths");
var _i18n = require("../../../../common/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSloFormattedSummary = slo => {
  const {
    http: {
      basePath
    },
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  return getSloFormattedSummary(slo, uiSettings, basePath);
};
exports.useSloFormattedSummary = useSloFormattedSummary;
const getSloFormattedSummary = (slo, uiSettings, basePath) => {
  var _slo$remote;
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const sliValue = slo.summary.status === 'NO_DATA' ? _i18n.NOT_AVAILABLE_LABEL : (0, _numeral.default)(slo.summary.sliValue).format(percentFormat);
  const sloTarget = (0, _numeral.default)(slo.objective.target).format(percentFormat);
  const errorBudgetRemaining = slo.summary.errorBudget.remaining <= 0 ? Math.trunc(slo.summary.errorBudget.remaining * 100) / 100 : slo.summary.errorBudget.remaining;
  const errorBudgetRemainingTitle = slo.summary.status === 'NO_DATA' ? _i18n.NOT_AVAILABLE_LABEL : (0, _numeral.default)(errorBudgetRemaining).format(percentFormat);
  const sloDetailsUrl = basePath.prepend(_paths.paths.sloDetails(slo.id, ![slo.groupBy].flat().includes(_sloSchema.ALL_VALUE) && slo.instanceId ? slo.instanceId : undefined, (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName));
  return {
    sloDetailsUrl,
    sliValue,
    sloTarget,
    errorBudgetRemaining: errorBudgetRemainingTitle
  };
};
exports.getSloFormattedSummary = getSloFormattedSummary;
const useSloFormattedSLIValue = sliValue => {
  const {
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const formattedSLIValue = sliValue !== undefined && sliValue !== null ? (0, _numeral.default)(sliValue).format(percentFormat) : null;
  return formattedSLIValue;
};
exports.useSloFormattedSLIValue = useSloFormattedSLIValue;