"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListView = SloListView;
var _eui = require("@elastic/eui");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _use_fetch_active_alerts = require("../../../../hooks/use_fetch_active_alerts");
var _use_fetch_historical_summary = require("../../../../hooks/use_fetch_historical_summary");
var _use_fetch_rules_for_slo = require("../../../../hooks/use_fetch_rules_for_slo");
var _slo_list_empty = require("../slo_list_empty");
var _slo_list_error = require("../slo_list_error");
var _slo_list_item = require("./slo_list_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloListView({
  sloList,
  loading,
  error
}) {
  const sloIdsAndInstanceIds = sloList.map(slo => {
    var _slo$instanceId;
    return [slo.id, (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE];
  });
  const {
    data: activeAlertsBySlo
  } = (0, _use_fetch_active_alerts.useFetchActiveAlerts)({
    sloIdsAndInstanceIds
  });
  const {
    data: rulesBySlo,
    refetchRules
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: sloIdsAndInstanceIds.map(item => item[0])
  });
  const {
    isLoading: historicalSummaryLoading,
    data: historicalSummaries = []
  } = (0, _use_fetch_historical_summary.useFetchHistoricalSummary)({
    sloList
  });
  if (!loading && !error && sloList.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_empty.SloListEmpty, null);
  }
  if (!loading && error) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_error.SloListError, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, sloList.map(slo => {
    var _slo$instanceId2, _historicalSummaries$;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${slo.id}-${(_slo$instanceId2 = slo.instanceId) !== null && _slo$instanceId2 !== void 0 ? _slo$instanceId2 : _sloSchema.ALL_VALUE}`
    }, /*#__PURE__*/_react.default.createElement(_slo_list_item.SloListItem, {
      activeAlerts: activeAlertsBySlo.get(slo),
      rules: rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo.id],
      historicalSummary: (_historicalSummaries$ = historicalSummaries.find(historicalSummary => {
        var _slo$instanceId3;
        return historicalSummary.sloId === slo.id && historicalSummary.instanceId === ((_slo$instanceId3 = slo.instanceId) !== null && _slo$instanceId3 !== void 0 ? _slo$instanceId3 : _sloSchema.ALL_VALUE);
      })) === null || _historicalSummaries$ === void 0 ? void 0 : _historicalSummaries$.data,
      historicalSummaryLoading: historicalSummaryLoading,
      slo: slo,
      refetchRules: refetchRules
    }));
  }));
}