"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupListView = GroupListView;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _kibana_react = require("../../../../utils/kibana_react");
var _paths = require("../../../../../common/locators/paths");
var _use_fetch_slo_list = require("../../../../hooks/use_fetch_slo_list");
var _constants = require("../../../slo_edit/constants");
var _use_slo_summary = require("../../hooks/use_slo_summary");
var _slos_view = require("../slos_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GroupListView({
  group,
  kqlQuery,
  sloView,
  sort,
  direction,
  groupBy,
  summary,
  filters
}) {
  var _summary$worst$slo, _summary$worst$slo2, _worst$slo, _worst$slo2;
  const groupQuery = `"${groupBy}": "${group}"`;
  const query = kqlQuery ? `${groupQuery} and ${kqlQuery}` : groupQuery;
  let groupName = group.toLowerCase();
  if (groupBy === 'slo.indicator.type') {
    var _SLI_OPTIONS$find$tex, _SLI_OPTIONS$find;
    groupName = (_SLI_OPTIONS$find$tex = (_SLI_OPTIONS$find = _constants.SLI_OPTIONS.find(option => option.value === group)) === null || _SLI_OPTIONS$find === void 0 ? void 0 : _SLI_OPTIONS$find.text) !== null && _SLI_OPTIONS$find$tex !== void 0 ? _SLI_OPTIONS$find$tex : group;
  }
  if (groupBy === '_index') {
    // get remote cluster name from index name
    if (groupName.includes(':.')) {
      const [remoteClusterName] = groupName.split(':.');
      groupName = _i18n.i18n.translate('xpack.slo.group.remoteCluster', {
        defaultMessage: 'Remote Cluster: {remoteClusterName}',
        values: {
          remoteClusterName
        }
      });
    } else {
      groupName = _i18n.i18n.translate('xpack.slo.group.remoteCluster.localKibana', {
        defaultMessage: 'Local Kibana'
      });
    }
  }
  const [page, setPage] = (0, _react.useState)(0);
  const [accordionState, setAccordionState] = (0, _react.useState)('closed');
  const onToggle = isOpen => {
    const newState = isOpen ? 'open' : 'closed';
    setAccordionState(newState);
  };
  const isAccordionOpen = accordionState === 'open';
  const {
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const [itemsPerPage, setItemsPerPage] = (0, _react.useState)(10);
  const {
    isLoading,
    isRefetching,
    isError,
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    kqlQuery: query,
    sortBy: sort,
    sortDirection: direction,
    perPage: itemsPerPage,
    page: page + 1,
    filters,
    disabled: !isAccordionOpen
  });
  const {
    results = [],
    total = 0
  } = sloList !== null && sloList !== void 0 ? sloList : {};
  const handlePageClick = pageNumber => {
    setPage(pageNumber);
  };
  const worstSLI = (0, _use_slo_summary.useSloFormattedSLIValue)(summary === null || summary === void 0 ? void 0 : summary.worst.sliValue);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "sloGroupViewPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(MemoEuiAccordion, {
    forceState: accordionState,
    onToggle: onToggle,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, groupName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, "(", summary === null || summary === void 0 ? void 0 : summary.total, ")"))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center"
    }, summary.violated > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger"
    }, _i18n.i18n.translate('xpack.slo.group.totalViolated', {
      defaultMessage: '{total} Violated',
      values: {
        total: summary === null || summary === void 0 ? void 0 : summary.violated
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: 'success'
    }, _i18n.i18n.translate('xpack.slo.group.totalHealthy', {
      defaultMessage: '{total} Healthy',
      values: {
        total: summary === null || summary === void 0 ? void 0 : summary.healthy
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('xpack.slo.group.totalSloViolatedTooltip', {
        defaultMessage: 'SLO: {name}',
        values: {
          name: summary === null || summary === void 0 ? void 0 : (_summary$worst$slo = summary.worst.slo) === null || _summary$worst$slo === void 0 ? void 0 : _summary$worst$slo.name
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('xpack.slo.group.totalSloViolatedTooltip.instance', {
        defaultMessage: 'Instance: {instance}',
        values: {
          instance: summary === null || summary === void 0 ? void 0 : (_summary$worst$slo2 = summary.worst.slo) === null || _summary$worst$slo2 === void 0 ? void 0 : _summary$worst$slo2.instanceId
        }
      })))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "o11yGroupListViewLink",
      href: basePath.prepend(_paths.paths.sloDetails((_worst$slo = summary.worst.slo) === null || _worst$slo === void 0 ? void 0 : _worst$slo.id, (_worst$slo2 = summary.worst.slo) === null || _worst$slo2 === void 0 ? void 0 : _worst$slo2.instanceId))
    }, _i18n.i18n.translate('xpack.slo.group.worstPerforming', {
      defaultMessage: 'Worst performing: '
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: (summary === null || summary === void 0 ? void 0 : summary.worst.status) !== 'HEALTHY' ? 'danger' : undefined
    }, /*#__PURE__*/_react.default.createElement("strong", null, worstSLI)))))),
    id: group,
    initialIsOpen: false
  }, isAccordionOpen && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_slos_view.SlosView, {
    sloList: results,
    loading: isLoading || isRefetching,
    error: isError,
    sloView: sloView
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    pageCount: Math.ceil(total / itemsPerPage),
    activePage: page,
    onChangePage: handlePageClick,
    itemsPerPage: itemsPerPage,
    onChangeItemsPerPage: perPage => setItemsPerPage(perPage)
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }));
}
const MemoEuiAccordion = /*#__PURE__*/(0, _react.memo)(_eui.EuiAccordion);