"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOGroupings = SLOGroupings;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SLOGroupings({
  slo,
  direction = 'row',
  truncate = true
}) {
  const groups = Object.entries((slo === null || slo === void 0 ? void 0 : slo.groupings) || []);
  const shouldTruncate = truncate && groups.length > 3;
  const firstThree = shouldTruncate ? groups.slice(0, 3) : groups;
  const rest = shouldTruncate ? groups.slice(3, groups.length) : [];
  const buttonCss = (0, _react2.css)`
    &:hover {
      text-decoration: none;
    }
  `;
  if (!groups.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldTruncate ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "sloGroupingsAccordion",
    arrowDisplay: "right",
    buttonElement: "div",
    buttonProps: {
      css: buttonCss
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: direction === 'column' ? 'flexStart' : 'center',
      gutterSize: "s",
      direction: direction
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(Entries, {
      entries: firstThree,
      direction: direction
    }), ' '), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, rest.length && /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "accordion",
      flush: "left"
    }, `(${_i18n.i18n.translate('xpack.slo.andLabel', {
      defaultMessage: 'and {count, plural, one {# more instance} other {# more instances}}',
      values: {
        count: rest.length
      }
    })})`)))))
  }, /*#__PURE__*/_react.default.createElement(Entries, {
    entries: rest,
    direction: direction
  })))) : /*#__PURE__*/_react.default.createElement(Entries, {
    entries: truncate ? firstThree : groups,
    direction: direction
  }));
}
function Entries({
  entries,
  direction
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: direction
  }, entries.map(([key, value]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: key
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, `${key}: `, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: `${value}`
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "sloInstanceCopy",
    style: {
      fontWeight: euiTheme.font.weight.semiBold
    },
    color: "text",
    onClick: e => {
      e.stopPropagation();
      copy();
    }
  }, `${value}`)))))));
}